"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TestPipeline = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _test_pipeline_logic = require("./test_pipeline_logic");
require("./add_inference_pipeline_flyout.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TestPipeline = () => {
  const {
    addInferencePipelineModal: {
      configuration: {
        sourceField,
        fieldMappings
      },
      indexName
    },
    getDocumentsErr,
    isGetDocumentsLoading,
    showGetDocumentErrors,
    simulateBody,
    simulatePipelineResult,
    simulatePipelineErrors
  } = (0, _kea.useValues)(_test_pipeline_logic.TestPipelineLogic);
  const {
    simulatePipeline,
    setPipelineSimulateBody,
    makeGetDocumentRequest
  } = (0, _kea.useActions)(_test_pipeline_logic.TestPipelineLogic);
  const isSmallerViewport = (0, _eui.useIsWithinMaxBreakpoint)('s');
  const inputRef = (0, _react.useRef)();
  const sampleFieldValue = _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.test.sampleValue', {
    defaultMessage: 'REPLACE ME'
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.test.title', {
    defaultMessage: 'Test your pipeline results'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 7
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.test.optionalCallout', {
    defaultMessage: 'This is an optional step.'
  })), "\xA0", _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.test.description', {
    defaultMessage: 'Use this tool to run a simulation of your pipeline in order to confirm that it produces your anticipated results.'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.test.addDocument', {
      defaultMessage: 'Search for a document'
    }),
    helpText: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.test.addDocument.helptext', {
      defaultMessage: 'Use a document to test your new pipeline. Search using document IDs'
    }),
    isInvalid: showGetDocumentErrors,
    error: getDocumentsErr
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    prepend: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.test.addDocument.documentId', {
      defaultMessage: 'Document ID'
    }),
    inputRef: ref => {
      inputRef.current = ref;
    },
    isInvalid: showGetDocumentErrors,
    isLoading: isGetDocumentsLoading,
    onKeyDown: e => {
      var _inputRef$current;
      if (e.key === 'Enter' && ((_inputRef$current = inputRef.current) === null || _inputRef$current === void 0 ? void 0 : _inputRef$current.value.trim().length) !== 0) {
        var _inputRef$current$val, _inputRef$current2;
        makeGetDocumentRequest({
          documentId: (_inputRef$current$val = (_inputRef$current2 = inputRef.current) === null || _inputRef$current2 === void 0 ? void 0 : _inputRef$current2.value.trim()) !== null && _inputRef$current$val !== void 0 ? _inputRef$current$val : '',
          indexName
        });
      }
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.test.or', {
    defaultMessage: 'Or'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.test.useJsonFormat', {
    defaultMessage: 'Use this JSON format to add your own array of documents'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    fontSize: "m",
    isCopyable: true,
    language: "json",
    paddingSize: "m"
  }, JSON.stringify(JSON.parse(`[{"_index":"index", "_id":"id", "_source":{${fieldMappings ? fieldMappings.map(fieldMapping => `"${fieldMapping.sourceField}": "${sampleFieldValue}"`).join(', ') : `"${sourceField}":"${sampleFieldValue}"`}}}]`), null, 2)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h5", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.test.subtitle.documents', {
    defaultMessage: 'Raw document'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h5", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.test.subtitle.result', {
    defaultMessage: 'Result'
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiResizableContainer, {
    direction: isSmallerViewport ? 'vertical' : 'horizontal',
    className: "resizableContainer"
  }, (EuiResizablePanel, EuiResizableButton) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(EuiResizablePanel, {
    grow: true,
    hasBorder: true,
    initialSize: 50,
    paddingSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_public.CodeEditor, {
    languageId: "json",
    options: {
      automaticLayout: true,
      lineNumbers: 'off',
      tabSize: 2
    },
    value: simulateBody,
    onChange: value => {
      setPipelineSimulateBody(value);
    }
  })), /*#__PURE__*/_react.default.createElement(EuiResizableButton, null), /*#__PURE__*/_react.default.createElement(EuiResizablePanel, {
    grow: true,
    hasBorder: true,
    initialSize: 50,
    paddingSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    isCopyable: true,
    className: "reviewCodeBlock"
  }, simulatePipelineErrors.length > 0 ? JSON.stringify(simulatePipelineErrors, null, 2) : simulatePipelineResult ? JSON.stringify(simulatePipelineResult, null, 2) : '{}'))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: simulatePipeline
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.test.runButton', {
    defaultMessage: 'Simulate Pipeline'
  })))))));
};
exports.TestPipeline = TestPipeline;