"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TargetFieldHelpText = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlTrainedModelsUtils = require("@kbn/ml-trained-models-utils");
var _ml_inference_pipeline = require("../../../../../../../common/ml_inference_pipeline");
var _utils = require("../../../shared/ml_inference/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TargetFieldHelpText = ({
  pipelineName,
  targetField,
  model
}) => {
  const baseText = targetField ? _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.fields.targetField.helpText.userProvided', {
    defaultMessage: 'This names the field that holds the inference result. It will be prefixed with "ml.inference", ml.inference.{targetField}',
    values: {
      targetField
    }
  }) : _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.fields.targetField.helpText.default', {
    defaultMessage: 'This names the field that holds the inference result. It will be prefixed with "ml.inference", if not set it will be defaulted to "ml.inference.{pipelineName}"',
    values: {
      pipelineName: pipelineName || '<Pipeline Name>'
    }
  });
  const fieldName = targetField || pipelineName || '<Pipeline Name>';
  const modelType = model ? (0, _utils.getMLType)((0, _ml_inference_pipeline.getMlModelTypesForModelConfig)(model)) : '';
  if (modelType === _mlTrainedModelsUtils.SUPPORTED_PYTORCH_TASKS.TEXT_CLASSIFICATION) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("p", null, baseText), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.fields.targetField.helpText.textClassificationModel",
      defaultMessage: "Additionally the predicted_value will be copied to \"{fieldName}\", if the prediction_probability is greater than {probabilityThreshold}",
      values: {
        fieldName,
        probabilityThreshold: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedNumber, {
          value: 0.5
        })
      }
    })));
  }
  if (modelType === _mlTrainedModelsUtils.SUPPORTED_PYTORCH_TASKS.TEXT_EMBEDDING) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("p", null, baseText), /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.fields.targetField.helpText.textEmbeddingModel', {
      defaultMessage: 'Additionally the predicted_value will be copied to "{fieldName}"',
      values: {
        fieldName
      }
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, baseText);
};
exports.TargetFieldHelpText = TargetFieldHelpText;