"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SingleFieldMapping = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _doc_links = require("../../../../../shared/doc_links");
var _index_view_logic = require("../../index_view_logic");
var _ml_inference_logic = require("./ml_inference_logic");
var _target_field_help_text = require("./target_field_help_text");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NoSourceFieldsError = () => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.fields.sourceField.error",
  defaultMessage: "Selecting a source field is required for pipeline configuration, but this index does not have a field mapping. {learnMore}",
  values: {
    learnMore: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: _doc_links.docLinks.elasticsearchMapping,
      target: "_blank",
      color: "danger"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.fields.sourceField.error.docLink', {
      defaultMessage: 'Learn more about field mapping'
    }))
  }
});
const SingleFieldMapping = () => {
  var _sourceFields$length, _sourceFields$map;
  const {
    addInferencePipelineModal: {
      configuration
    },
    formErrors,
    supportedMLModels,
    sourceFields
  } = (0, _kea.useValues)(_ml_inference_logic.MLInferenceLogic);
  const {
    setInferencePipelineConfiguration
  } = (0, _kea.useActions)(_ml_inference_logic.MLInferenceLogic);
  const {
    ingestionMethod
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const {
    destinationField,
    modelID,
    pipelineName,
    sourceField
  } = configuration;
  const isEmptySourceFields = ((_sourceFields$length = sourceFields === null || sourceFields === void 0 ? void 0 : sourceFields.length) !== null && _sourceFields$length !== void 0 ? _sourceFields$length : 0) === 0;
  const areInputsDisabled = configuration.existingPipeline !== false;
  const selectedModel = supportedMLModels.find(model => model.model_id === modelID);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.fields.sourceFieldLabel', {
      defaultMessage: 'Source field'
    }),
    error: isEmptySourceFields && /*#__PURE__*/_react.default.createElement(NoSourceFieldsError, null),
    isInvalid: isEmptySourceFields
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-pipelines-configureFields-selectSchemaField`,
    disabled: areInputsDisabled,
    value: sourceField,
    options: [{
      disabled: true,
      text: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.fields.sourceField.placeholder', {
        defaultMessage: 'Select a schema field'
      }),
      value: ''
    }, ...((_sourceFields$map = sourceFields === null || sourceFields === void 0 ? void 0 : sourceFields.map(field => ({
      text: field,
      value: field
    }))) !== null && _sourceFields$map !== void 0 ? _sourceFields$map : [])],
    onChange: e => setInferencePipelineConfiguration({
      ...configuration,
      sourceField: e.target.value
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.fields.targetField.label', {
      defaultMessage: 'Target field (optional)'
    }),
    helpText: formErrors.destinationField === undefined && configuration.existingPipeline !== true && /*#__PURE__*/_react.default.createElement(_target_field_help_text.TargetFieldHelpText, {
      pipelineName: pipelineName,
      targetField: destinationField,
      model: selectedModel
    }),
    error: formErrors.destinationField,
    isInvalid: formErrors.destinationField !== undefined,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-pipelines-configureFields-targetField`,
    disabled: areInputsDisabled,
    placeholder: "custom_field_name",
    value: destinationField,
    onChange: e => setInferencePipelineConfiguration({
      ...configuration,
      destinationField: e.target.value
    }),
    fullWidth: true
  })))));
};
exports.SingleFieldMapping = SingleFieldMapping;