"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SyncRulesStateCallouts = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _connectors = require("../../../../../../../common/types/connectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SyncRulesStateCallouts = ({
  applyDraft,
  editDraft,
  state
}) => {
  switch (state) {
    case _connectors.FilteringValidationState.EDITED:
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        color: "warning",
        title: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, _i18n.i18n.translate('xpack.enterpriseSearch.index.connector.syncRules.validatingTitle', {
          defaultMessage: 'Draft sync rules are validating'
        })))
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "column"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, _i18n.i18n.translate('xpack.enterpriseSearch.index.connector.syncRules.validatingDescription', {
        defaultMessage: 'Draft rules need to be validated before they can be activated. This may take a few minutes.'
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-telemetry-id": "entSearchContent-connector-syncRules-validatingCallout-editRules",
        onClick: editDraft,
        color: "warning",
        fill: true
      }, _i18n.i18n.translate('xpack.enterpriseSearch.index.connector.syncRules.validatingCallout.editDraftRulesTitle', {
        defaultMessage: 'Edit draft rules'
      }))))));
    case _connectors.FilteringValidationState.INVALID:
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        color: "danger",
        iconType: "cross",
        title: _i18n.i18n.translate('xpack.enterpriseSearch.index.connector.syncRules.invalidTitle', {
          defaultMessage: 'Draft sync rules are invalid'
        })
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "column"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, _i18n.i18n.translate('xpack.enterpriseSearch.index.connector.syncRules.invalidDescription', {
        defaultMessage: 'Draft rules did not validate. Edit the draft rules before they can be activated.'
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-telemetry-id": "entSearchContent-connector-syncRules-errorCallout-editRules",
        onClick: editDraft,
        color: "danger",
        fill: true
      }, _i18n.i18n.translate('xpack.enterpriseSearch.index.connector.syncRules.errorCallout.editDraftRulesTitle', {
        defaultMessage: 'Edit draft rules'
      }))))));
    case _connectors.FilteringValidationState.VALID:
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        color: "success",
        iconType: "check",
        title: _i18n.i18n.translate('xpack.enterpriseSearch.index.connector.syncRules.validatedTitle', {
          defaultMessage: 'Draft sync rules validated'
        })
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "column"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, _i18n.i18n.translate('xpack.enterpriseSearch.index.connector.syncRules.validatedDescription', {
        defaultMessage: 'Activate draft rules to take effect on the next sync.'
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        justifyContent: "flexStart"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-telemetry-id": "entSearchContent-connector-syncRules-successCallout-applyRules",
        onClick: applyDraft,
        color: "success",
        fill: true
      }, _i18n.i18n.translate('xpack.enterpriseSearch.index.connector.syncRules.successCallout.applyDraftRulesTitle', {
        defaultMessage: 'Activate draft rules'
      })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-telemetry-id": "entSearchContent-connector-syncRules-successCallout-editRules",
        onClick: editDraft,
        color: "success"
      }, _i18n.i18n.translate('xpack.enterpriseSearch.index.connector.syncRules.errorCallout.successEditDraftRulesTitle', {
        defaultMessage: 'Edit draft rules'
      }))))))));
    default:
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
};
exports.SyncRulesStateCallouts = SyncRulesStateCallouts;