"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorContentScheduling = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _connectors = require("../../../../../../../common/types/connectors");
var _platinum_license_popover = require("../../../shared/platinum_license_popover/platinum_license_popover");
var _connector_scheduling_logic = require("../connector_scheduling_logic");
var _connector_cron_editor = require("./connector_cron_editor");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAccordionTitle = type => {
  switch (type) {
    case _connectors.SyncJobType.FULL:
      {
        return _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.connectorScheduling.accordion.fullSync.title', {
          defaultMessage: 'Full content sync'
        });
      }
    case _connectors.SyncJobType.INCREMENTAL:
      {
        return _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.connectorScheduling.accordion.incrementalSync.title', {
          defaultMessage: 'Incremental content sync'
        });
      }
    case _connectors.SyncJobType.ACCESS_CONTROL:
      {
        return _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.connectorScheduling.accordion.accessControlSync.title', {
          defaultMessage: 'Access Control Sync'
        });
      }
  }
};
const getDescriptionText = type => {
  switch (type) {
    case _connectors.SyncJobType.FULL:
      {
        return _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.connectorScheduling.accordion.fullSync.description', {
          defaultMessage: 'Synchronize all data from your data source.'
        });
      }
    case _connectors.SyncJobType.INCREMENTAL:
      {
        return _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.connectorScheduling.accordion.incrementalSync.description', {
          defaultMessage: 'A lightweight sync job that only fetches updated content from your data source.'
        });
      }
    case _connectors.SyncJobType.ACCESS_CONTROL:
      {
        return _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.connectorScheduling.accordion.accessControlSync.description', {
          defaultMessage: 'Schedule access control syncs to keep permissions mappings up to date.'
        });
      }
  }
};
const EnableSwitch = ({
  disabled,
  checked,
  onChange
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
  disabled: disabled,
  checked: checked,
  label: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.connectorScheduling.switch.label', {
    defaultMessage: 'Enabled'
  }),
  onChange: onChange
});
const ConnectorContentScheduling = ({
  type,
  index,
  hasPlatinumLicense = false
}) => {
  var _index$connector$conf;
  const {
    setHasChanges,
    updateScheduling
  } = (0, _kea.useActions)(_connector_scheduling_logic.ConnectorSchedulingLogic);
  const schedulingInput = index.connector.scheduling;
  const [scheduling, setScheduling] = (0, _react.useState)(schedulingInput);
  const [isAccordionOpen, setIsAccordionOpen] = (0, _react.useState)(scheduling[type].enabled ? 'open' : 'closed');
  const [isPlatinumPopoverOpen, setIsPlatinumPopoverOpen] = (0, _react.useState)(false);
  const isGated = !hasPlatinumLicense && type === _connectors.SyncJobType.ACCESS_CONTROL;
  const isDocumentLevelSecurityDisabled = !((_index$connector$conf = index.connector.configuration.use_document_level_security) !== null && _index$connector$conf !== void 0 && _index$connector$conf.value);
  const isEnableSwitchDisabled = type === _connectors.SyncJobType.ACCESS_CONTROL && (!hasPlatinumLicense || isDocumentLevelSecurityDisabled);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    paddingSize: "m",
    id: `${type}-content-sync-schedule`,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h4", null, getAccordionTitle(type)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("p", null, getDescriptionText(type))))),
    forceState: isAccordionOpen,
    onToggle: isOpen => {
      setIsAccordionOpen(isOpen ? 'open' : 'closed');
    },
    extraAction: isGated ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_platinum_license_popover.PlatinumLicensePopover, {
      isPopoverOpen: isPlatinumPopoverOpen,
      closePopover: () => setIsPlatinumPopoverOpen(!isPlatinumPopoverOpen),
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.selectConnector.openPopoverLabel', {
          defaultMessage: 'Open licensing popover'
        }),
        iconType: "questionInCircle",
        onClick: () => setIsPlatinumPopoverOpen(!isPlatinumPopoverOpen)
      })
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(EnableSwitch, {
      disabled: isEnableSwitchDisabled,
      checked: scheduling[type].enabled,
      onChange: e => {
        if (e.target.checked) {
          setIsAccordionOpen('open');
        }
        setScheduling({
          ...scheduling,
          ...{
            [type]: {
              enabled: e.target.checked,
              interval: scheduling[type].interval
            }
          }
        });
        setHasChanges(type);
      }
    }))) : /*#__PURE__*/_react.default.createElement(EnableSwitch, {
      disabled: isEnableSwitchDisabled,
      checked: scheduling[type].enabled,
      onChange: e => {
        if (e.target.checked) {
          setIsAccordionOpen('open');
        }
        setScheduling({
          ...scheduling,
          ...{
            [type]: {
              enabled: e.target.checked,
              interval: scheduling[type].interval
            }
          }
        });
        setHasChanges(type);
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_connector_cron_editor.ConnectorCronEditor, {
    disabled: isGated,
    frequencyBlockList: type === _connectors.SyncJobType.ACCESS_CONTROL ? [] : undefined,
    scheduling: scheduling[type],
    type: type,
    onReset: () => {
      setScheduling({
        ...schedulingInput
      });
    },
    onSave: interval => {
      updateScheduling(type, {
        connectorId: index.connector.id,
        scheduling: {
          ...index.connector.scheduling,
          [type]: {
            ...scheduling[type],
            interval
          }
        }
      });
    }
  }))))));
};
exports.ConnectorContentScheduling = ConnectorContentScheduling;