"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorConfigurationForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _api = require("../../../../../../common/types/api");
var _kibana = require("../../../../shared/kibana");
var _update_connector_configuration_api_logic = require("../../../api/connector/update_connector_configuration_api_logic");
var _connector_configuration_form_items = require("./connector_configuration_form_items");
var _connector_configuration_logic = require("./connector_configuration_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorConfigurationForm = () => {
  const {
    productFeatures
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const {
    status
  } = (0, _kea.useValues)(_update_connector_configuration_api_logic.ConnectorConfigurationApiLogic);
  const {
    localConfigView
  } = (0, _kea.useValues)(_connector_configuration_logic.ConnectorConfigurationLogic);
  const {
    saveConfig,
    setIsEditing
  } = (0, _kea.useActions)(_connector_configuration_logic.ConnectorConfigurationLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    onSubmit: event => {
      event.preventDefault();
      saveConfig();
    },
    component: "form"
  }, /*#__PURE__*/_react.default.createElement(_connector_configuration_form_items.ConnectorConfigurationFormItems, {
    items: localConfigView.unCategorizedItems,
    hasDocumentLevelSecurityEnabled: productFeatures.hasDocumentLevelSecurityEnabled
  }), localConfigView.categories.map((category, index) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    key: index
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, category.label)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_connector_configuration_form_items.ConnectorConfigurationFormItems, {
    items: category.configEntries,
    hasDocumentLevelSecurityEnabled: productFeatures.hasDocumentLevelSecurityEnabled
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "entSearchContent-connector-configuration-saveConfiguration",
    "data-telemetry-id": "entSearchContent-connector-configuration-saveConfiguration",
    type: "submit",
    isLoading: status === _api.Status.LOADING
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.config.submitButton.title', {
    defaultMessage: 'Save configuration'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-telemetry-id": "entSearchContent-connector-configuration-cancelEdit",
    isDisabled: status === _api.Status.LOADING,
    onClick: () => {
      setIsEditing(false);
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.config.cancelEditingButton.title', {
    defaultMessage: 'Cancel'
  }))))));
};
exports.ConnectorConfigurationForm = ConnectorConfigurationForm;