"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManageKeysPopover = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _kibana = require("../../../../../shared/kibana");
var _index_view_logic = require("../../index_view_logic");
var _overview = require("../../overview.logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ManageKeysPopover = () => {
  const {
    isManageKeysPopoverOpen
  } = (0, _kea.useValues)(_overview.OverviewLogic);
  const {
    ingestionMethod
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const {
    toggleManageApiKeyPopover,
    openGenerateModal
  } = (0, _kea.useActions)(_overview.OverviewLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isManageKeysPopoverOpen,
    closePopover: toggleManageApiKeyPopover,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      iconType: "arrowDown",
      iconSide: "right",
      onClick: toggleManageApiKeyPopover
    }, _i18n.i18n.translate('xpack.enterpriseSearch.content.overview.documentExample.generateApiKeyButton.label', {
      defaultMessage: 'Manage API keys'
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "viewApiKeys",
      "data-telemetry-id": `entSearchContent-${ingestionMethod}-overview-generateApiKeys-viewApiKeys`,
      icon: "eye",
      onClick: () => _kibana.KibanaLogic.values.navigateToUrl('/app/management/security/api_keys', {
        shouldNotCreateHref: true
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.overview.documementExample.generateApiKeyButton.viewAll', {
      defaultMessage: 'View all API keys'
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "createNewApiKey",
      "data-telemetry-id": `entSearchContent-${ingestionMethod}-overview-generateApiKeys-createNewApiKey`,
      icon: "plusInCircle",
      onClick: openGenerateModal
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.overview.documementExample.generateApiKeyButton.createNew', {
      defaultMessage: 'Create a new API key'
    }))))]
  }));
};
exports.ManageKeysPopover = ManageKeysPopover;