"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _result = require("../../../../../shared/result/result");
var _result_metadata = require("../../../../../shared/result/result_metadata");
var _index_view_logic = require("../../index_view_logic");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DocumentList = ({
  docs,
  docsPerPage,
  isLoading,
  mappings,
  meta,
  onPaginate,
  setDocsPerPage
}) => {
  const {
    ingestionMethod
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const resultToField = result => {
    if (mappings && result._source && !Array.isArray(result._source)) {
      if (typeof result._source === 'object') {
        return Object.entries(result._source).map(([key, value]) => {
          var _mappings$key$type, _mappings$key;
          return {
            fieldName: key,
            fieldType: (_mappings$key$type = (_mappings$key = mappings[key]) === null || _mappings$key === void 0 ? void 0 : _mappings$key.type) !== null && _mappings$key$type !== void 0 ? _mappings$key$type : 'object',
            fieldValue: JSON.stringify(value, null, 2)
          };
        });
      }
    }
    return [];
  };
  const getIconType = size => {
    return size === docsPerPage ? 'check' : 'empty';
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPagination, {
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.documents.documentList.paginationAriaLabel', {
      defaultMessage: 'Pagination for document list'
    }),
    pageCount: meta.page.total_pages,
    activePage: meta.page.current,
    onPageClick: onPaginate
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.content.searchIndex.documents.documentList.description",
    defaultMessage: "Showing {results} of {total}. Search results maxed at {maximum} documents.",
    values: {
      maximum: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedNumber, {
        value: 10000
      }),
      results: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedNumber, {
        value: docs.length
      })),
      total: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedNumber, {
        value: meta.page.total_results
      }))
    }
  }))), isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "primary"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), docs.map(doc => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      key: doc._id
    }, /*#__PURE__*/_react.default.createElement(_result.Result, {
      fields: resultToField(doc),
      metaData: (0, _result_metadata.resultMetaData)(doc)
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }));
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPagination, {
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.documents.documentList.paginationAriaLabel', {
      defaultMessage: 'Pagination for document list'
    }),
    pageCount: meta.page.total_pages,
    activePage: meta.page.current,
    onPageClick: onPaginate
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.documents.documentList.docsPerPage', {
      defaultMessage: 'Document count per page dropdown'
    }),
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-telemetry-id": `entSearchContent-${ingestionMethod}-documents-docsPerPage`,
      size: "s",
      iconType: "arrowDown",
      iconSide: "right",
      onClick: () => {
        setIsPopoverOpen(true);
      }
    }, _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.documents.documentList.pagination.itemsPerPage', {
      defaultMessage: 'Documents per page: {docPerPage}',
      values: {
        docPerPage: docsPerPage
      }
    })),
    isOpen: isPopoverOpen,
    closePopover: () => {
      setIsPopoverOpen(false);
    },
    panelPaddingSize: "none",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "10 rows",
      icon: getIconType(10),
      onClick: () => {
        setIsPopoverOpen(false);
        setDocsPerPage(10);
      }
    }, _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.documents.documentList.paginationOptions.option', {
      defaultMessage: '{docCount} documents',
      values: {
        docCount: 10
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "25 rows",
      icon: getIconType(25),
      onClick: () => {
        setIsPopoverOpen(false);
        setDocsPerPage(25);
      }
    }, _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.documents.documentList.paginationOptions.option', {
      defaultMessage: '{docCount} documents',
      values: {
        docCount: 25
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "50 rows",
      icon: getIconType(50),
      onClick: () => {
        setIsPopoverOpen(false);
        setDocsPerPage(50);
      }
    }, _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.documents.documentList.paginationOptions.option', {
      defaultMessage: '{docCount} documents',
      values: {
        docCount: 50
      }
    }))]
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), meta.page.total_results > 9999 && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.content.searchIndex.documents.documentList.resultLimitTitle",
      defaultMessage: "Results are limited to {number} documents",
      values: {
        number: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedNumber, {
          value: 10000
        })
      }
    }),
    iconType: "search"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.content.searchIndex.documents.documentList.resultLimit",
    defaultMessage: "Only the first {number} results are available for paging. Please use the search bar to filter down your results.",
    values: {
      number: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedNumber, {
        value: 10000
      })
    }
  }))));
};
exports.DocumentList = DocumentList;