"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorCheckable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../shared/constants");
require("./connector_checkable.scss");
var _platinum_license_popover = require("../../shared/platinum_license_popover/platinum_license_popover");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorCheckable = ({
  disabled,
  documentationUrl,
  icon,
  isBeta,
  isTechPreview,
  showNativeBadge,
  name,
  serviceType,
  ...props
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCheckableCard, (0, _extends2.default)({}, props, {
    disabled: disabled,
    id: `checkableCard-${serviceType}`,
    className: "connectorCheckable",
    "data-telemetry-id": `entSearchContent-connector-selectConnector-${serviceType}-select`,
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      responsive: false
    }, icon && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: icon
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, disabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "disabledText",
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h3", null, name)) : /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h2", null, name))), disabled && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_platinum_license_popover.PlatinumLicensePopover, {
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.selectConnector.openPopoverLabel', {
          defaultMessage: 'Open licensing popover'
        }),
        iconType: "questionInCircle",
        onClick: () => setIsPopoverOpen(!isPopoverOpen)
      }),
      closePopover: () => setIsPopoverOpen(false),
      isPopoverOpen: isPopoverOpen
    }))),
    name: name,
    value: serviceType
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, documentationUrl && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    href: documentationUrl
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.selectConnector.connectorCheckable.documentationLinkLabel', {
    defaultMessage: 'Documentation'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    justifyContent: "flexStart",
    responsive: false
  }, showNativeBadge && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    isDisabled: disabled
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, _constants.NATIVE_LABEL))), isBeta && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    isDisabled: disabled
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, _constants.BETA_LABEL))), isTechPreview && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    iconType: "beaker",
    isDisabled: disabled
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.selectConnector.connectorCheckable.techPreviewLabel', {
    defaultMessage: 'Tech preview'
  }))))))));
};
exports.ConnectorCheckable = ConnectorCheckable;