"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.postConnectorConfiguration = exports.ConnectorConfigurationApiLogic = void 0;
var _i18n = require("@kbn/i18n");
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const postConnectorConfiguration = async ({
  configuration,
  connectorId,
  indexName
}) => {
  const route = `/internal/enterprise_search/connectors/${connectorId}/configuration`;
  const responseConfig = await _http.HttpLogic.values.http.post(route, {
    body: JSON.stringify(configuration)
  });
  return {
    configuration: responseConfig,
    indexName
  };
};
exports.postConnectorConfiguration = postConnectorConfiguration;
const ConnectorConfigurationApiLogic = (0, _create_api_logic.createApiLogic)(['content', 'configuration_connector_api_logic'], postConnectorConfiguration, {
  showSuccessFlashFn: () => _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.configuration.successToast.title', {
    defaultMessage: 'Configuration updated'
  })
});
exports.ConnectorConfigurationApiLogic = ConnectorConfigurationApiLogic;