"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchApplicationSearchPreview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _eui = require("@elastic/eui");
var _reactSearchUi = require("@elastic/react-search-ui");
var _searchUiEnginesConnector = _interopRequireDefault(require("@elastic/search-ui-engines-connector"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _doc_links = require("../../../../shared/doc_links");
var _encode_path_params = require("../../../../shared/encode_path_params");
var _http = require("../../../../shared/http");
var _kibana = require("../../../../shared/kibana");
var _telemetry = require("../../../../shared/telemetry");
var _routes = require("../../../routes");
var _page_template = require("../../layout/page_template");
var _search_application_indices_logic = require("../search_application_indices_logic");
var _search_application_view_logic = require("../search_application_view_logic");
var _api_call_flyout = require("./api_call_flyout");
var _document_context = require("./document_context");
var _document_flyout = require("./document_flyout");
var _search_preview_logic = require("./search_preview_logic");
var _search_ui_components = require("./search_ui_components");
require("../search_application_layout.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class InternalSearchApplicationTransporter {
  constructor(http, searchApplicationName, setLastAPICall) {
    this.http = http;
    this.searchApplicationName = searchApplicationName;
    this.setLastAPICall = setLastAPICall;
  }
  async performRequest(request) {
    const url = `/internal/enterprise_search/search_applications/${this.searchApplicationName}/search`;
    const response = await this.http.post(url, {
      body: JSON.stringify(request)
    });
    this.setLastAPICall({
      request,
      response
    });
    const withUniqueIds = {
      ...response,
      hits: {
        ...response.hits,
        hits: response.hits.hits.map(hit => ({
          ...hit,
          // The `__id` field is the actual document ID.
          __id: hit._id,
          // Search UI expects a unique `_id` for use as a React key but
          // because Search Applications can have multiple indices, keys
          // can be duplicated. Here we prefix the `_id` with the index
          // name to ensure uniqueness.
          _id: `${hit._index}__${hit._id}`
        }))
      }
    };
    return withUniqueIds;
  }
}
const ConfigurationPopover = ({
  searchApplicationName,
  hasSchemaConflicts,
  setCloseConfiguration,
  showConfiguration
}) => {
  const {
    navigateToUrl
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const {
    searchApplicationData
  } = (0, _kea.useValues)(_search_application_view_logic.SearchApplicationViewLogic);
  const {
    openDeleteSearchApplicationModal
  } = (0, _kea.useActions)(_search_application_view_logic.SearchApplicationViewLogic);
  const {
    sendEnterpriseSearchTelemetry
  } = (0, _kea.useActions)(_telemetry.TelemetryLogic);
  const [isTourClosed, setTourClosed] = (0, _useLocalStorage.default)('search-application-tour-closed', false);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "downCenter",
    isOpen: showConfiguration,
    panelPaddingSize: "none",
    closePopover: setCloseConfiguration,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "xs"
    }, hasSchemaConflicts && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "alert",
      color: "danger"
    })), !isTourClosed && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, {
      display: "block",
      decoration: "beacon",
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.searchPreview.configuration.tourContent', {
        defaultMessage: 'Create your API key, learn about using language clients and find more resources in Connect.'
      }))),
      isStepOpen: !isTourClosed,
      maxWidth: 360,
      hasArrow: true,
      step: 1,
      onFinish: () => {
        setTourClosed(true);
      },
      stepsTotal: 1,
      anchorPosition: "downCenter",
      title: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.searchPreview.configuration.tourTitle', {
        defaultMessage: 'Review our API page to start using your search application'
      })
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      color: "primary",
      iconType: "arrowDown",
      iconSide: "right",
      onClick: setCloseConfiguration
    }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.searchPreview.configuration.buttonTitle', {
      defaultMessage: 'Configuration'
    }))))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    style: {
      width: 300
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.searchPreview.configuration.contentTitle', {
    defaultMessage: 'Content'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "Indices",
    icon: "tableDensityExpanded",
    onClick: () => navigateToUrl((0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_APPLICATION_CONTENT_PATH, {
      contentTabId: _routes.SearchApplicationContentTabs.INDICES,
      searchApplicationName
    }))
  }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.searchPreview.configuration.content.Indices', {
    defaultMessage: 'Indices'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "Schema",
    icon: hasSchemaConflicts ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "warning",
      color: "danger"
    }) : 'kqlField',
    onClick: () => navigateToUrl((0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_APPLICATION_CONTENT_PATH, {
      contentTabId: _routes.SearchApplicationContentTabs.SCHEMA,
      searchApplicationName
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchApplications.searchApplication.searchPreview.configuration.content.schema",
    defaultMessage: "Schema"
  }), hasSchemaConflicts && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "danger"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchApplications.searchApplication.searchPreview.configuration.content.schemaConflict",
    defaultMessage: "Conflict"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.searchPreview.configuration.connectTitle', {
    defaultMessage: 'Connect'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "Api",
    icon: "lock",
    onClick: () => navigateToUrl((0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_APPLICATION_CONNECT_PATH, {
      connectTabId: _routes.SearchApplicationConnectTabs.SEARCHAPI,
      searchApplicationName
    }))
  }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.searchPreview.configuration.connect.Api', {
    defaultMessage: 'API'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.searchPreview.configuration.settingsTitle', {
    defaultMessage: 'Settings'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "delete",
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "trash",
      color: "danger"
    }),
    onClick: () => {
      if (searchApplicationData) {
        openDeleteSearchApplicationModal();
        sendEnterpriseSearchTelemetry({
          action: 'clicked',
          metric: 'entSearchApplications-searchApplicationView-deleteSearchApplication'
        });
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "danger"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.searchPreview.configuration.settings.delete', {
    defaultMessage: 'Delete this app'
  })))))));
};
const SearchApplicationSearchPreview = () => {
  const {
    http
  } = (0, _kea.useValues)(_http.HttpLogic);
  const [showAPICallFlyout, setShowAPICallFlyout] = (0, _react.useState)(false);
  const [showConfigurationPopover, setShowConfigurationPopover] = (0, _react.useState)(false);
  const [lastAPICall, setLastAPICall] = (0, _react.useState)(null);
  const {
    searchApplicationName,
    isLoadingSearchApplication,
    hasSchemaConflicts
  } = (0, _kea.useValues)(_search_application_view_logic.SearchApplicationViewLogic);
  const {
    resultFields,
    sortableFields
  } = (0, _kea.useValues)(_search_preview_logic.SearchApplicationSearchPreviewLogic);
  const {
    searchApplicationData
  } = (0, _kea.useValues)(_search_application_indices_logic.SearchApplicationIndicesLogic);
  const config = (0, _react.useMemo)(() => {
    const transporter = new InternalSearchApplicationTransporter(http, searchApplicationName, setLastAPICall);
    const connector = new _searchUiEnginesConnector.default(transporter);
    return {
      alwaysSearchOnInitialLoad: true,
      apiConnector: connector,
      hasA11yNotifications: true,
      searchQuery: {
        result_fields: resultFields
      }
    };
  }, [http, searchApplicationName, setLastAPICall, resultFields]);
  if (!searchApplicationData) return null;
  return /*#__PURE__*/_react.default.createElement(_page_template.EnterpriseSearchApplicationsPageTemplate, {
    pageChrome: [searchApplicationName, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.searchPreview.pageChrome', {
      defaultMessage: 'Search Preview'
    })],
    pageViewTelemetry: _routes.SearchApplicationViewTabs.PREVIEW,
    isLoading: isLoadingSearchApplication,
    pageHeader: {
      bottomBorder: false,
      className: 'searchApplicationHeaderBackgroundColor',
      pageTitle: searchApplicationName,
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(ConfigurationPopover, {
        searchApplicationName: searchApplicationName,
        hasSchemaConflicts: hasSchemaConflicts,
        showConfiguration: showConfigurationPopover,
        setCloseConfiguration: () => setShowConfigurationPopover(!showConfigurationPopover)
      }))]
    },
    searchApplicationName: searchApplicationName,
    hasSchemaConflicts: hasSchemaConflicts
  }, /*#__PURE__*/_react.default.createElement(_document_context.DocumentProvider, null, /*#__PURE__*/_react.default.createElement(_reactSearchUi.SearchProvider, {
    config: config
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_reactSearchUi.SearchBox, {
    inputView: ({
      getInputProps
    }) => /*#__PURE__*/_react.default.createElement(_search_ui_components.SearchBar, {
      additionalInputProps: getInputProps({
        append: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
          color: "primary",
          iconType: "eye",
          onClick: () => setShowAPICallFlyout(true),
          isLoading: lastAPICall == null
        }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.searchPreview.inputView.appendButtonLabel', {
          defaultMessage: 'View API call'
        })),
        placeholder: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.searchPreview.inputView.placeholder', {
          defaultMessage: 'Search'
        })
      })
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      minWidth: '240px'
    }
  }, /*#__PURE__*/_react.default.createElement(_reactSearchUi.ResultsPerPage, {
    view: _search_ui_components.ResultsPerPageView,
    options: _search_ui_components.RESULTS_PER_PAGE_OPTIONS
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_search_ui_components.Sorting, {
    sortableFields: sortableFields
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: _doc_links.docLinks.searchTemplates,
    target: "_blank"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchApplications.searchApplication.searchPreview.improveResultsLink",
    defaultMessage: "Improve these results"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_reactSearchUi.PagingInfo, {
    view: _search_ui_components.PagingInfoView
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_reactSearchUi.Results, {
    view: _search_ui_components.ResultsView,
    resultView: _search_ui_components.ResultView
  })))), /*#__PURE__*/_react.default.createElement(_document_flyout.DocumentFlyout, null), showAPICallFlyout && lastAPICall && /*#__PURE__*/_react.default.createElement(_api_call_flyout.APICallFlyout, {
    onClose: () => setShowAPICallFlyout(false),
    lastAPICall: lastAPICall,
    searchApplicationName: searchApplicationName
  })));
};
exports.SearchApplicationSearchPreview = SearchApplicationSearchPreview;