"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateSearchApplication = exports.UpdateSearchApplicationApiLogic = void 0;
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const updateSearchApplication = async ({
  name,
  indices
}) => {
  const route = `/internal/enterprise_search/search_applications/${name}`;
  return await _http.HttpLogic.values.http.put(route, {
    body: JSON.stringify({
      indices,
      name
    })
  });
};
exports.updateSearchApplication = updateSearchApplication;
const UpdateSearchApplicationApiLogic = (0, _create_api_logic.createApiLogic)(['searchApplications', 'update_search_application_api_logic'], updateSearchApplication);
exports.UpdateSearchApplicationApiLogic = UpdateSearchApplicationApiLogic;