"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchSearchApplications = exports.FetchSearchApplicationsAPILogic = void 0;
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchSearchApplications = async ({
  meta,
  searchQuery
}) => {
  const route = '/internal/enterprise_search/search_applications';
  const query = {
    from: meta.from,
    size: meta.size,
    ...(searchQuery && searchQuery.trim() !== '' ? {
      q: searchQuery + '*'
    } : {})
  };
  const response = await _http.HttpLogic.values.http.get(route, {
    query
  });
  return {
    ...response,
    params: query
  };
};
exports.fetchSearchApplications = fetchSearchApplications;
const FetchSearchApplicationsAPILogic = (0, _create_api_logic.createApiLogic)(['searchApplications', 'search_applications_api_logic'], fetchSearchApplications);
exports.FetchSearchApplicationsAPILogic = FetchSearchApplicationsAPILogic;