"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EngineCreation = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _constants = require("../../../shared/constants");
var _query_params = require("../../../shared/query_params");
var _engines = require("../engines");
var _layout = require("../layout");
var _configure_app_search_engine = require("./configure_app_search_engine");
var _configure_elasticsearch_engine = require("./configure_elasticsearch_engine");
var _constants2 = require("./constants");
var _engine_creation_logic = require("./engine_creation_logic");
var _review_elasticsearch_engine = require("./review_elasticsearch_engine");
var _select_engine_type = require("./select_engine_type");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EngineCreation = () => {
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const {
    method,
    ...params
  } = (0, _query_params.parseQueryParams)(search);
  const {
    engineType,
    currentEngineCreationStep
  } = (0, _kea.useValues)(_engine_creation_logic.EngineCreationLogic);
  const {
    setIngestionMethod,
    initializeWithESIndex
  } = (0, _kea.useActions)(_engine_creation_logic.EngineCreationLogic);
  (0, _react.useEffect)(() => {
    if (typeof method === 'string') {
      setIngestionMethod(method);
    }
    const esIndexParam = params[_constants.ESINDEX_QUERY_PARAMETER];
    if (typeof esIndexParam === 'string') {
      initializeWithESIndex(esIndexParam);
    }
  }, []);
  return /*#__PURE__*/_react.default.createElement(_layout.AppSearchPageTemplate, {
    pageChrome: [_engines.ENGINES_TITLE, _constants2.ENGINE_CREATION_TITLE],
    pageHeader: {
      pageTitle: _constants2.ENGINE_CREATION_TITLE
    },
    "data-test-subj": "EngineCreation"
  }, currentEngineCreationStep === _engine_creation_logic.EngineCreationSteps.SelectStep && /*#__PURE__*/_react.default.createElement(_select_engine_type.SelectEngineType, null), currentEngineCreationStep === _engine_creation_logic.EngineCreationSteps.ConfigureStep && engineType === 'appSearch' && /*#__PURE__*/_react.default.createElement(_configure_app_search_engine.ConfigureAppSearchEngine, null), currentEngineCreationStep === _engine_creation_logic.EngineCreationSteps.ConfigureStep && engineType === 'elasticsearch' && /*#__PURE__*/_react.default.createElement(_configure_elasticsearch_engine.ConfigureElasticsearchEngine, null), currentEngineCreationStep === _engine_creation_logic.EngineCreationSteps.ReviewStep && /*#__PURE__*/_react.default.createElement(_review_elasticsearch_engine.ReviewElasticsearchEngine, null));
};
exports.EngineCreation = EngineCreation;