"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MoreDocumentsText = exports.ExampleDocumentJson = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExampleDocumentJson = ({
  document,
  errors
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, errors && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documentCreation.showSummary.documentNotIndexed', {
    defaultMessage: 'This document was not indexed!'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), errors.map((errorMessage, index) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: index
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    size: "s",
    title: errorMessage
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    paddingSize: "m",
    overflowHeight: 200
  }, JSON.stringify(document, null, 2)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
exports.ExampleDocumentJson = ExampleDocumentJson;
const MoreDocumentsText = ({
  documents
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documentCreation.showSummary.otherDocuments', {
    defaultMessage: 'and {documents, number} other {documents, plural, one {document} other {documents}}.',
    values: {
      documents
    }
  })));
};
exports.MoreDocumentsText = MoreDocumentsText;