"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormKeyReadWriteAccess = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _credentials_logic = require("../../credentials_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FormKeyReadWriteAccess = () => {
  const {
    setTokenReadWrite
  } = (0, _kea.useActions)(_credentials_logic.CredentialsLogic);
  const {
    activeApiToken
  } = (0, _kea.useValues)(_credentials_logic.CredentialsLogic);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.credentials.formReadWrite.label', {
    defaultMessage: 'Read and Write Access Levels'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.credentials.formReadWrite.helpText', {
    defaultMessage: 'Only applies to Private API Keys.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    name: "read",
    id: "read",
    checked: activeApiToken.read,
    onChange: e => setTokenReadWrite(e.target),
    label: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.credentials.formReadWrite.readLabel', {
      defaultMessage: 'Read Access'
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    name: "write",
    id: "write",
    checked: activeApiToken.write,
    onChange: e => setTokenReadWrite(e.target),
    label: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.credentials.formReadWrite.writeLabel', {
      defaultMessage: 'Write Access'
    })
  })));
};
exports.FormKeyReadWriteAccess = FormKeyReadWriteAccess;