"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryClicksTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react_router_helpers = require("../../../../../shared/react_router_helpers");
var _routes = require("../../../../routes");
var _documents = require("../../../documents");
var _engine = require("../../../engine");
var _shared_columns = require("./shared_columns");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const QueryClicksTable = ({
  items
}) => {
  const {
    engineName
  } = _engine.EngineLogic.values;
  const DOCUMENT_COLUMN = {
    ..._shared_columns.FIRST_COLUMN_PROPS,
    field: 'document',
    name: _documents.DOCUMENTS_TITLE,
    render: (document, query) => {
      return document ? /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
        to: (0, _engine.generateEnginePath)(_routes.ENGINE_DOCUMENT_DETAIL_PATH, {
          engineName,
          documentId: document.id
        })
      }, document.id) : query.key;
    }
  };
  const CLICKS_COLUMN = {
    ..._shared_columns.COUNT_COLUMN_PROPS,
    field: 'doc_count',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.table.clicksColumn', {
      defaultMessage: 'Clicks'
    })
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: [DOCUMENT_COLUMN, _shared_columns.TAGS_LIST_COLUMN, CLICKS_COLUMN],
    items: items,
    responsive: true,
    noItemsMessage: /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "visLine",
      title: /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.table.empty.noClicksTitle', {
        defaultMessage: 'No clicks'
      })),
      body: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.table.empty.noClicksDescription', {
        defaultMessage: 'No documents have been clicked from this query.'
      })
    })
  });
};
exports.QueryClicksTable = QueryClicksTable;