"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyticsRouter = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _routes = require("../../routes");
var _engine = require("../engine");
var _not_found = require("../not_found");
var _constants = require("./constants");
var _views = require("./views");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AnalyticsRouter = () => {
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Switch, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _routes.ENGINE_ANALYTICS_PATH
  }, /*#__PURE__*/_react.default.createElement(_views.Analytics, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _routes.ENGINE_ANALYTICS_TOP_QUERIES_PATH
  }, /*#__PURE__*/_react.default.createElement(_views.TopQueries, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _routes.ENGINE_ANALYTICS_TOP_QUERIES_NO_RESULTS_PATH
  }, /*#__PURE__*/_react.default.createElement(_views.TopQueriesNoResults, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _routes.ENGINE_ANALYTICS_TOP_QUERIES_NO_CLICKS_PATH
  }, /*#__PURE__*/_react.default.createElement(_views.TopQueriesNoClicks, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _routes.ENGINE_ANALYTICS_TOP_QUERIES_WITH_CLICKS_PATH
  }, /*#__PURE__*/_react.default.createElement(_views.TopQueriesWithClicks, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _routes.ENGINE_ANALYTICS_RECENT_QUERIES_PATH
  }, /*#__PURE__*/_react.default.createElement(_views.RecentQueries, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _routes.ENGINE_ANALYTICS_QUERY_DETAIL_PATH
  }, /*#__PURE__*/_react.default.createElement(_views.QueryDetail, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _routes.ENGINE_ANALYTICS_QUERY_DETAILS_PATH
  }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: (0, _engine.generateEnginePath)(_routes.ENGINE_ANALYTICS_PATH)
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, null, /*#__PURE__*/_react.default.createElement(_not_found.NotFound, {
    pageChrome: (0, _engine.getEngineBreadcrumbs)([_constants.ANALYTICS_TITLE])
  })));
};
exports.AnalyticsRouter = AnalyticsRouter;