"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyticsLayout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _kibana = require("../../../shared/kibana");
var _engine = require("../engine");
var _layout = require("../layout");
var _log_retention = require("../log_retention");
var _components = require("./components");
var _constants = require("./constants");
var _ = require(".");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AnalyticsLayout = ({
  title,
  breadcrumbs = [],
  isQueryView,
  isAnalyticsView,
  children
}) => {
  const {
    history
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const {
    query
  } = (0, _reactRouterDom.useParams)();
  const {
    dataLoading
  } = (0, _kea.useValues)(_.AnalyticsLogic);
  const {
    loadAnalyticsData,
    loadQueryData
  } = (0, _kea.useActions)(_.AnalyticsLogic);
  (0, _react.useEffect)(() => {
    if (isQueryView) loadQueryData(query);
    if (isAnalyticsView) loadAnalyticsData();
  }, [history.location.search]);
  return /*#__PURE__*/_react.default.createElement(_layout.AppSearchPageTemplate, {
    pageChrome: (0, _engine.getEngineBreadcrumbs)([_constants.ANALYTICS_TITLE, ...breadcrumbs]),
    pageHeader: {
      pageTitle: title,
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_log_retention.LogRetentionTooltip, {
        type: _log_retention.LogRetentionOptions.Analytics,
        position: "left"
      })],
      children: /*#__PURE__*/_react.default.createElement(_components.AnalyticsFilters, null),
      responsive: false
    },
    isLoading: dataLoading
  }, /*#__PURE__*/_react.default.createElement(_log_retention.LogRetentionCallout, {
    type: _log_retention.LogRetentionOptions.Analytics
  }), children);
};
exports.AnalyticsLayout = AnalyticsLayout;