"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddableEnhancedPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/ui-actions-enhanced-plugin/public");
var _embeddable_action_storage = require("./embeddables/embeddable_action_storage");
var _actions = require("./actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class EmbeddableEnhancedPlugin {
  constructor(_context) {
    (0, _defineProperty2.default)(this, "uiActions", void 0);
    (0, _defineProperty2.default)(this, "isEmbeddableContext", context => {
      if (!(context !== null && context !== void 0 && context.embeddable)) {
        // eslint-disable-next-line no-console
        console.warn('For drilldowns to work action context should contain .embeddable field.');
        return false;
      }
      return true;
    });
    this.context = _context;
  }
  setup(core, plugins) {
    this.setCustomEmbeddableFactoryProvider(plugins);
    const panelNotificationAction = new _actions.PanelNotificationsAction();
    plugins.uiActionsEnhanced.registerAction(panelNotificationAction);
    plugins.uiActionsEnhanced.attachAction(_public.PANEL_NOTIFICATION_TRIGGER, panelNotificationAction.id);
    return {};
  }
  start(core, plugins) {
    this.uiActions = plugins.uiActionsEnhanced;
    return {};
  }
  stop() {}
  setCustomEmbeddableFactoryProvider(plugins) {
    plugins.embeddable.setCustomEmbeddableFactoryProvider(def => {
      const factory = (0, _public.defaultEmbeddableFactoryProvider)(def);
      return {
        ...factory,
        create: async (...args) => {
          const embeddable = await factory.create(...args);
          if (!embeddable) return embeddable;
          return this.enhanceEmbeddableWithDynamicActions(embeddable);
        },
        createFromSavedObject: async (...args) => {
          const embeddable = await factory.createFromSavedObject(...args);
          if (!embeddable) return embeddable;
          return this.enhanceEmbeddableWithDynamicActions(embeddable);
        }
      };
    });
  }
  enhanceEmbeddableWithDynamicActions(embeddable) {
    const enhancedEmbeddable = embeddable;
    const storage = new _embeddable_action_storage.EmbeddableActionStorage(embeddable);
    const dynamicActions = new _public2.UiActionsEnhancedDynamicActionManager({
      isCompatible: async context => {
        if (!this.isEmbeddableContext(context)) return false;
        return context.embeddable.runtimeId === embeddable.runtimeId;
      },
      storage,
      uiActions: this.uiActions
    });
    dynamicActions.start().catch(error => {
      /* eslint-disable no-console */

      console.log('Failed to start embeddable dynamic actions', embeddable);
      console.error(error);
      /* eslint-enable */
    });

    const stop = () => {
      dynamicActions.stop().catch(error => {
        /* eslint-disable no-console */

        console.log('Failed to stop embeddable dynamic actions', embeddable);
        console.error(error);
        /* eslint-enable */
      });
    };

    embeddable.getInput$().subscribe({
      next: () => {
        storage.reload$.next();
      },
      error: stop,
      complete: stop
    });
    enhancedEmbeddable.enhancements = {
      ...enhancedEmbeddable.enhancements,
      dynamicActions
    };
    return enhancedEmbeddable;
  }
}
exports.EmbeddableEnhancedPlugin = EmbeddableEnhancedPlugin;