"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IgnoredReason = void 0;
exports.getIgnoredReason = getIgnoredReason;
var _public = require("@kbn/data-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
let IgnoredReason;
/**
 * Returns the reason why a specific field was ignored in the response.
 * Will return undefined if the field had no ignored values in it.
 * This implementation will make some assumptions based on specific types
 * of ignored values can only happen with specific field types in Elasticsearch.
 *
 * @param field Either the data view field or the string name of it.
 * @param ignoredFields The hit._ignored value of the hit to validate.
 */
exports.IgnoredReason = IgnoredReason;
(function (IgnoredReason) {
  IgnoredReason["IGNORE_ABOVE"] = "ignore_above";
  IgnoredReason["MALFORMED"] = "malformed";
  IgnoredReason["UNKNOWN"] = "unknown";
})(IgnoredReason || (exports.IgnoredReason = IgnoredReason = {}));
function getIgnoredReason(field, ignoredFields) {
  const fieldName = typeof field === 'string' ? field : field.name;
  if (!(ignoredFields !== null && ignoredFields !== void 0 && ignoredFields.includes(fieldName))) {
    return undefined;
  }
  if (typeof field === 'string') {
    return IgnoredReason.UNKNOWN;
  }
  switch (field.type) {
    case _public.KBN_FIELD_TYPES.STRING:
      return IgnoredReason.IGNORE_ABOVE;
    case _public.KBN_FIELD_TYPES.NUMBER:
    case _public.KBN_FIELD_TYPES.DATE:
    case _public.KBN_FIELD_TYPES.GEO_POINT:
    case _public.KBN_FIELD_TYPES.GEO_SHAPE:
    case _public.KBN_FIELD_TYPES.IP:
      return IgnoredReason.MALFORMED;
    default:
      return IgnoredReason.UNKNOWN;
  }
}