"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFieldCapabilities = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getFieldCapabilities = (dataView, field) => {
  var _dataView$getFieldByN;
  const isRuntimeField = Boolean((_dataView$getFieldByN = dataView.getFieldByName(field.name)) === null || _dataView$getFieldByN === void 0 ? void 0 : _dataView$getFieldByN.runtimeField);
  const isUnknownField = field.type === 'unknown' || field.type === 'unknown_selected';
  return {
    canEdit: !isUnknownField || isRuntimeField,
    canDelete: isRuntimeField
  };
};
exports.getFieldCapabilities = getFieldCapabilities;