"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocViewerTab = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _doc_viewer_render_tab = require("./doc_viewer_render_tab");
var _doc_viewer_render_error = require("./doc_viewer_render_error");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Renders the tab content of a doc view.
 * Displays an error message when it encounters exceptions, thanks to
 * Error Boundaries.
 */
class DocViewerTab extends _react.default.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      hasError: false,
      error: ''
    });
  }
  static getDerivedStateFromError(error) {
    // Update state so the next render will show the fallback UI.
    return {
      hasError: true,
      error
    };
  }
  shouldComponentUpdate(nextProps, nextState) {
    return nextProps.renderProps.hit.id !== this.props.renderProps.hit.id || !(0, _lodash.isEqual)(nextProps.renderProps.hit.raw.highlight, this.props.renderProps.hit.raw.highlight) || nextProps.id !== this.props.id || !(0, _lodash.isEqual)(nextProps.renderProps.columns, this.props.renderProps.columns) || nextState.hasError;
  }
  render() {
    const {
      component: Component,
      render,
      renderProps,
      title
    } = this.props;
    const {
      hasError,
      error
    } = this.state;
    if (hasError && error) {
      return /*#__PURE__*/_react.default.createElement(_doc_viewer_render_error.DocViewerError, {
        error: error
      });
    }
    if (render) {
      // doc view is provided by a render function
      return /*#__PURE__*/_react.default.createElement(_doc_viewer_render_tab.DocViewRenderTab, {
        render: render,
        renderProps: renderProps
      });
    }

    // doc view is provided by a react component
    if (Component) {
      return /*#__PURE__*/_react.default.createElement(Component, renderProps);
    }
    return /*#__PURE__*/_react.default.createElement(_doc_viewer_render_error.DocViewerError, {
      error: `Invalid plugin ${title}, there is neither a (react) component nor a render function provided`
    });
  }
}
exports.DocViewerTab = DocViewerTab;