"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocViewer = DocViewer;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _kibana_services = require("../../../../kibana_services");
var _doc_viewer_tab = require("./doc_viewer_tab");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Rendering tabs with different views of 1 Elasticsearch hit in Discover.
 * The tabs are provided by the `docs_views` registry.
 * A view can contain a React `component`, or any JS framework by using
 * a `render` function.
 */
function DocViewer(renderProps) {
  const docViewsRegistry = (0, _kibana_services.getDocViewsRegistry)();
  const tabs = docViewsRegistry.getDocViewsSorted(renderProps.hit).map(({
    title,
    render,
    component
  }, idx) => {
    return {
      id: `kbn_doc_viewer_tab_${idx}`,
      name: title,
      content: /*#__PURE__*/_react.default.createElement(_doc_viewer_tab.DocViewerTab, {
        id: idx,
        title: title,
        component: component,
        renderProps: renderProps,
        render: render
      }),
      ['data-test-subj']: `docViewerTab-${idx}`
    };
  });
  if (!tabs.length) {
    // There there's a minimum of 2 tabs active in Discover.
    // This condition takes care of unit tests with 0 tabs.
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "kbnDocViewer",
    "data-test-subj": "kbnDocViewer"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    size: "s",
    tabs: tabs
  }));
}