"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToolBarPagination = exports.MAX_ROWS_PER_PAGE_OPTION = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _uiTheme = require("@kbn/ui-theme");
var _rows_per_page = require("../../../../utils/rows_per_page");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const MAX_ROWS_PER_PAGE_OPTION = 100;
exports.MAX_ROWS_PER_PAGE_OPTION = MAX_ROWS_PER_PAGE_OPTION;
const TOOL_BAR_PAGINATION_STYLES = {
  marginLeft: 'auto',
  marginRight: _uiTheme.euiLightVars.euiSizeL
};
const ToolBarPagination = ({
  pageSize,
  pageCount,
  activePage,
  onPageSizeChange,
  onPageClick
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const rowsWord = _i18n.i18n.translate('discover.docTable.rows', {
    defaultMessage: 'rows'
  });
  const onChooseRowsClick = () => setIsPopoverOpen(prevIsPopoverOpen => !prevIsPopoverOpen);
  const closePopover = () => setIsPopoverOpen(false);
  const getIconType = size => {
    return size === pageSize ? 'check' : 'empty';
  };
  const rowsPerPageOptions = (0, _rows_per_page.getRowsPerPageOptions)(pageSize).filter(option => option <= MAX_ROWS_PER_PAGE_OPTION) // legacy table is not optimized well for rendering more rows at once
  .map(cur => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: `${cur} rows`,
    icon: getIconType(cur),
    onClick: () => {
      closePopover();
      onPageSizeChange(cur);
    }
  }, cur, " ", rowsWord));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      color: "text",
      iconType: "arrowDown",
      iconSide: "right",
      onClick: onChooseRowsClick
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "discover.docTable.rowsPerPage",
      defaultMessage: "Rows per page: {pageSize}",
      values: {
        pageSize
      }
    })),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: rowsPerPageOptions
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: TOOL_BAR_PAGINATION_STYLES
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPagination, {
    "aria-label": _i18n.i18n.translate('discover.docTable.documentsNavigation', {
      defaultMessage: 'Documents navigation'
    }),
    pageCount: pageCount,
    activePage: activePage,
    onPageClick: onPageClick,
    compressed: true
  })));
};
exports.ToolBarPagination = ToolBarPagination;