"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSchemaByKbnType = getSchemaByKbnType;
exports.getSchemaDetectors = getSchemaDetectors;
var _public = require("@kbn/data-plugin/public");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getSchemaByKbnType(kbnType) {
  // Default DataGrid schemas: boolean, numeric, datetime, json, currency, string
  switch (kbnType) {
    case _public.KBN_FIELD_TYPES.IP:
    case _public.KBN_FIELD_TYPES.GEO_SHAPE:
    case _public.KBN_FIELD_TYPES.NUMBER:
      return 'numeric';
    case _public.KBN_FIELD_TYPES.BOOLEAN:
      return 'boolean';
    case _public.KBN_FIELD_TYPES.STRING:
      return 'string';
    case _public.KBN_FIELD_TYPES.DATE:
      return 'datetime';
    default:
      return _constants.kibanaJSON;
  }
}
function getSchemaDetectors() {
  return [{
    type: _constants.kibanaJSON,
    detector() {
      return 0; // this schema is always explicitly defined
    },

    sortTextAsc: '',
    sortTextDesc: '',
    icon: '',
    color: ''
  }];
}