"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpandButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _uiTheme = require("@kbn/ui-theme");
var _i18n = require("@kbn/i18n");
var _discover_grid_context = require("./discover_grid_context");
var _discover_tour = require("../discover_tour");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Button to expand a given row
 */
const ExpandButton = ({
  rowIndex,
  setCellProps
}) => {
  const toolTipRef = (0, _react.useRef)(null);
  const [pressed, setPressed] = (0, _react.useState)(false);
  const {
    expanded,
    setExpanded,
    rows,
    isDarkMode
  } = (0, _react.useContext)(_discover_grid_context.DiscoverGridContext);
  const current = rows[rowIndex];
  (0, _react.useEffect)(() => {
    if (current.isAnchor) {
      setCellProps({
        className: 'dscDocsGrid__cell--highlight'
      });
    } else if (expanded && current && expanded.id === current.id) {
      setCellProps({
        style: {
          backgroundColor: isDarkMode ? _uiTheme.euiDarkVars.euiColorHighlight : _uiTheme.euiLightVars.euiColorHighlight
        }
      });
    } else {
      setCellProps({
        style: undefined
      });
    }
  }, [expanded, current, setCellProps, isDarkMode]);
  const isCurrentRowExpanded = current === expanded;
  const buttonLabel = _i18n.i18n.translate('discover.grid.viewDoc', {
    defaultMessage: 'Toggle dialog with details'
  });
  const testSubj = current.isAnchor ? 'docTableExpandToggleColumnAnchor' : 'docTableExpandToggleColumn';
  (0, _react.useEffect)(() => {
    if (!isCurrentRowExpanded && pressed) {
      setPressed(false);
      setTimeout(() => {
        var _toolTipRef$current;
        (_toolTipRef$current = toolTipRef.current) === null || _toolTipRef$current === void 0 ? void 0 : _toolTipRef$current.hideToolTip();
      }, 100);
    }
  }, [isCurrentRowExpanded, setPressed, pressed]);
  if (!setExpanded) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: buttonLabel,
    delay: "long",
    ref: toolTipRef
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    id: rowIndex === 0 ? _discover_tour.DISCOVER_TOUR_STEP_ANCHOR_IDS.expandDocument : undefined,
    size: "xs",
    iconSize: "s",
    "aria-label": buttonLabel,
    "data-test-subj": testSubj,
    onClick: () => {
      var _toolTipRef$current2;
      const nextHit = isCurrentRowExpanded ? undefined : current;
      (_toolTipRef$current2 = toolTipRef.current) === null || _toolTipRef$current2 === void 0 ? void 0 : _toolTipRef$current2.hideToolTip();
      setPressed(Boolean(nextHit));
      setExpanded === null || setExpanded === void 0 ? void 0 : setExpanded(nextHit);
    },
    color: isCurrentRowExpanded ? 'primary' : 'text',
    iconType: isCurrentRowExpanded ? 'minimize' : 'expand',
    isSelected: isCurrentRowExpanded
  }));
};
exports.ExpandButton = ExpandButton;