"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildEditFieldButton = void 0;
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _get_field_capabilities = require("../../utils/get_field_capabilities");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const buildEditFieldButton = ({
  hasEditDataViewPermission,
  dataView,
  field,
  editField
}) => {
  if (field.name === '_source') {
    return null;
  }
  const {
    canEdit: canEditField
  } = (0, _get_field_capabilities.getFieldCapabilities)(dataView, field);
  const canEditDataView = hasEditDataViewPermission() || !dataView.isPersisted();
  if (!canEditField || !canEditDataView) {
    return null;
  }
  const editFieldButton = {
    size: 'xs',
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "discover.grid.editFieldButton",
      defaultMessage: "Edit data view field"
    }),
    iconType: 'pencil',
    iconProps: {
      size: 'm'
    },
    onClick: () => {
      editField(field.name);
    },
    'data-test-subj': 'gridEditFieldButton'
  };
  return editFieldButton;
};
exports.buildEditFieldButton = buildEditFieldButton;