"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ViewAlertRoute = ViewAlertRoute;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _use_discover_services = require("../../hooks/use_discover_services");
var _use_alert_results_toast = require("../main/hooks/use_alert_results_toast");
var _view_alert_utils = require("./view_alert_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const isActualAlert = queryParams => {
  return Boolean(queryParams.from && queryParams.to);
};
function ViewAlertRoute() {
  const {
    core,
    data,
    locator,
    toastNotifications
  } = (0, _use_discover_services.useDiscoverServices)();
  const {
    id
  } = (0, _reactRouterDom.useParams)();
  const history = (0, _reactRouterDom.useHistory)();
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const query = (0, _react.useMemo)(() => new URLSearchParams(search), [search]);
  const queryParams = (0, _react.useMemo)(() => ({
    from: query.get('from'),
    to: query.get('to')
  }), [query]);

  /**
   * This flag indicates whether we should open the actual alert results or current state of documents.
   */
  const openActualAlert = (0, _react.useMemo)(() => isActualAlert(queryParams), [queryParams]);
  (0, _react.useEffect)(() => {
    const {
      fetchAlert,
      fetchSearchSource,
      buildLocatorParams
    } = (0, _view_alert_utils.getAlertUtils)(openActualAlert, queryParams, toastNotifications, core, data);
    const navigateWithDiscoverState = state => {
      if (openActualAlert) {
        (0, _use_alert_results_toast.displayPossibleDocsDiffInfoAlert)(toastNotifications);
      }
      locator.navigate(state);
    };
    const navigateToDiscoverRoot = () => locator.navigate({});
    fetchAlert(id).then(fetchSearchSource).then(buildLocatorParams).then(navigateWithDiscoverState).catch(navigateToDiscoverRoot);
  }, [core, data, history, id, locator, openActualAlert, queryParams, toastNotifications]);
  return null;
}