"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchDocuments = void 0;
var _i18n = require("@kbn/i18n");
var _operators = require("rxjs/operators");
var _rxjs = require("rxjs");
var _public = require("@kbn/data-plugin/public");
var _build_data_record = require("../../../utils/build_data_record");
var _common = require("../../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Requests the documents for Discover. This will return a promise that will resolve
 * with the documents.
 */
const fetchDocuments = (searchSource, {
  abortController,
  inspectorAdapters,
  searchSessionId,
  services
}) => {
  var _searchSource$getFiel;
  searchSource.setField('size', services.uiSettings.get(_common.SAMPLE_SIZE_SETTING));
  searchSource.setField('trackTotalHits', false);
  searchSource.setField('highlightAll', true);
  searchSource.setField('version', true);
  if (((_searchSource$getFiel = searchSource.getField('index')) === null || _searchSource$getFiel === void 0 ? void 0 : _searchSource$getFiel.type) === 'rollup') {
    // We treat that data view as "normal" even if it was a rollup data view,
    // since the rollup endpoint does not support querying individual documents, but we
    // can get them from the regular _search API that will be used if the data view
    // not a rollup data view.
    searchSource.setOverwriteDataViewType(undefined);
  }
  const dataView = searchSource.getField('index');
  const executionContext = {
    description: 'fetch documents'
  };
  const fetch$ = searchSource.fetch$({
    abortSignal: abortController.signal,
    sessionId: searchSessionId,
    inspector: {
      adapter: inspectorAdapters.requests,
      title: _i18n.i18n.translate('discover.inspectorRequestDataTitleDocuments', {
        defaultMessage: 'Documents'
      }),
      description: _i18n.i18n.translate('discover.inspectorRequestDescriptionDocument', {
        defaultMessage: 'This request queries Elasticsearch to fetch the documents.'
      })
    },
    executionContext
  }).pipe((0, _operators.filter)(res => (0, _public.isCompleteResponse)(res)), (0, _operators.map)(res => {
    return (0, _build_data_record.buildDataTableRecordList)(res.rawResponse.hits.hits, dataView);
  }));
  return (0, _rxjs.lastValueFrom)(fetch$).then(records => ({
    records
  }));
};
exports.fetchDocuments = fetchDocuments;