"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.showOpenSearchPanel = showOpenSearchPanel;
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _public = require("@kbn/kibana-react-plugin/public");
var _open_search_panel = require("./open_search_panel");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

let isOpen = false;
function showOpenSearchPanel({
  I18nContext,
  onOpenSavedSearch,
  theme$,
  services
}) {
  if (isOpen) {
    return;
  }
  isOpen = true;
  const container = document.createElement('div');
  const onClose = () => {
    _reactDom.default.unmountComponentAtNode(container);
    document.body.removeChild(container);
    isOpen = false;
  };
  document.body.appendChild(container);
  const element = /*#__PURE__*/_react.default.createElement(I18nContext, null, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: services
  }, /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
    theme$: theme$
  }, /*#__PURE__*/_react.default.createElement(_open_search_panel.OpenSearchPanel, {
    onClose: onClose,
    onOpenSavedSearch: onOpenSavedSearch
  }))));
  _reactDom.default.render(element, container);
}