"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDiscoverHistogram = void 0;
var _public = require("@kbn/unified-field-list-plugin/public");
var _public2 = require("@kbn/unified-histogram-plugin/public");
var _lodash = require("lodash");
var _react = require("react");
var _rxjs = require("rxjs");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _use_discover_services = require("../../../../hooks/use_discover_services");
var _kibana_services = require("../../../../kibana_services");
var _types = require("../../../types");
var _use_data_state = require("../../hooks/use_data_state");
var _use_saved_search_messages = require("../../hooks/use_saved_search_messages");
var _add_log = require("../../../../utils/add_log");
var _discover_internal_state_container = require("../../services/discover_internal_state_container");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const useDiscoverHistogram = ({
  stateContainer,
  inspectorAdapters,
  hideChart,
  isPlainRecord
}) => {
  var _savedSearchData$$doc, _savedSearchData$$doc2;
  const services = (0, _use_discover_services.useDiscoverServices)();
  const savedSearchData$ = stateContainer.dataState.data$;

  /**
   * API initialization
   */

  const [unifiedHistogram, ref] = (0, _react.useState)();
  const getCreationOptions = (0, _react.useCallback)(() => {
    const {
      hideChart: chartHidden,
      interval: timeInterval,
      breakdownField
    } = stateContainer.appState.getState();
    const {
      fetchStatus: totalHitsStatus,
      result: totalHitsResult
    } = savedSearchData$.totalHits$.getValue();
    return {
      localStorageKeyPrefix: 'discover',
      disableAutoFetching: true,
      initialState: {
        chartHidden,
        timeInterval,
        breakdownField,
        totalHitsStatus: totalHitsStatus.toString(),
        totalHitsResult
      }
    };
  }, [savedSearchData$.totalHits$, stateContainer.appState]);

  /**
   * Sync Unified Histogram state with Discover state
   */

  (0, _react.useEffect)(() => {
    var _createUnifiedHistogr;
    const subscription = (_createUnifiedHistogr = createUnifiedHistogramStateObservable(unifiedHistogram === null || unifiedHistogram === void 0 ? void 0 : unifiedHistogram.state$)) === null || _createUnifiedHistogr === void 0 ? void 0 : _createUnifiedHistogr.subscribe(changes => {
      const {
        lensRequestAdapter,
        ...stateChanges
      } = changes;
      const appState = stateContainer.appState.getState();
      const oldState = {
        hideChart: appState.hideChart,
        interval: appState.interval,
        breakdownField: appState.breakdownField
      };
      const newState = {
        ...oldState,
        ...stateChanges
      };
      if ('lensRequestAdapter' in changes) {
        inspectorAdapters.lensRequests = lensRequestAdapter;
      }
      if (!(0, _lodash.isEqual)(oldState, newState)) {
        stateContainer.appState.update(newState);
      }
    });
    return () => {
      subscription === null || subscription === void 0 ? void 0 : subscription.unsubscribe();
    };
  }, [inspectorAdapters, stateContainer.appState, unifiedHistogram === null || unifiedHistogram === void 0 ? void 0 : unifiedHistogram.state$]);

  /**
   * Override Unified Histgoram total hits with Discover partial results
   */

  const firstLoadComplete = (0, _react.useRef)(false);
  const {
    fetchStatus: totalHitsStatus,
    result: totalHitsResult
  } = (0, _use_data_state.useDataState)(savedSearchData$.totalHits$);
  (0, _react.useEffect)(() => {
    // We only want to show the partial results on the first load,
    // or there will be a flickering effect as the loading spinner
    // is quickly shown and hidden again on fetches
    if (!firstLoadComplete.current) {
      unifiedHistogram === null || unifiedHistogram === void 0 ? void 0 : unifiedHistogram.setTotalHits({
        totalHitsStatus: totalHitsStatus.toString(),
        totalHitsResult
      });
    }
  }, [totalHitsResult, totalHitsStatus, unifiedHistogram]);

  /**
   * Sync URL query params with Unified Histogram
   */

  (0, _react.useEffect)(() => {
    const subscription = createAppStateObservable(stateContainer.appState.state$).subscribe(changes => {
      if ('breakdownField' in changes) {
        unifiedHistogram === null || unifiedHistogram === void 0 ? void 0 : unifiedHistogram.setBreakdownField(changes.breakdownField);
      }
      if ('timeInterval' in changes && changes.timeInterval) {
        unifiedHistogram === null || unifiedHistogram === void 0 ? void 0 : unifiedHistogram.setTimeInterval(changes.timeInterval);
      }
      if ('chartHidden' in changes && typeof changes.chartHidden === 'boolean') {
        unifiedHistogram === null || unifiedHistogram === void 0 ? void 0 : unifiedHistogram.setChartHidden(changes.chartHidden);
      }
    });
    return () => {
      subscription === null || subscription === void 0 ? void 0 : subscription.unsubscribe();
    };
  }, [stateContainer.appState.state$, unifiedHistogram]);

  /**
   * Total hits
   */

  const setTotalHitsError = (0, _react.useMemo)(() => (0, _use_saved_search_messages.sendErrorTo)(savedSearchData$.totalHits$), [savedSearchData$.totalHits$]);
  (0, _react.useEffect)(() => {
    var _createTotalHitsObser;
    const subscription = (_createTotalHitsObser = createTotalHitsObservable(unifiedHistogram === null || unifiedHistogram === void 0 ? void 0 : unifiedHistogram.state$)) === null || _createTotalHitsObser === void 0 ? void 0 : _createTotalHitsObser.subscribe(({
      status,
      result
    }) => {
      if (result instanceof Error) {
        // Set totalHits$ to an error state
        setTotalHitsError(result);
        return;
      }
      const {
        recordRawType
      } = savedSearchData$.totalHits$.getValue();

      // Sync the totalHits$ observable with the unified histogram state
      savedSearchData$.totalHits$.next({
        fetchStatus: status.toString(),
        result,
        recordRawType
      });
      if (status !== _public2.UnifiedHistogramFetchStatus.complete || typeof result !== 'number') {
        return;
      }

      // Check the hits count to set a partial or no results state
      (0, _use_saved_search_messages.checkHitCount)(savedSearchData$.main$, result);

      // Indicate the first load has completed so we don't show
      // partial results on subsequent fetches
      firstLoadComplete.current = true;
    });
    return () => {
      subscription === null || subscription === void 0 ? void 0 : subscription.unsubscribe();
    };
  }, [savedSearchData$.main$, savedSearchData$.totalHits$, setTotalHitsError, unifiedHistogram === null || unifiedHistogram === void 0 ? void 0 : unifiedHistogram.state$]);

  /**
   * Request params
   */
  const {
    query,
    filters
  } = (0, _public.useQuerySubscriber)({
    data: services.data
  });
  const timefilter = services.data.query.timefilter.timefilter;
  const timeRange = timefilter.getAbsoluteTime();
  const relativeTimeRange = (0, _useObservable.default)(timefilter.getTimeUpdate$().pipe((0, _rxjs.map)(() => timefilter.getTime())), timefilter.getTime());

  // When in text based language mode, update the data view, query, and
  // columns only when documents are done fetching so the Lens suggestions
  // don't frequently change, such as when the user modifies the table
  // columns, which would trigger unnecessary refetches.
  const textBasedFetchComplete$ = (0, _react.useMemo)(() => createFetchCompleteObservable(stateContainer), [stateContainer]);
  const {
    dataView: textBasedDataView,
    query: textBasedQuery,
    columns
  } = (0, _useObservable.default)(textBasedFetchComplete$, {
    dataView: stateContainer.internalState.getState().dataView,
    query: stateContainer.appState.getState().query,
    columns: (_savedSearchData$$doc = (_savedSearchData$$doc2 = savedSearchData$.documents$.getValue().textBasedQueryColumns) === null || _savedSearchData$$doc2 === void 0 ? void 0 : _savedSearchData$$doc2.map(({
      name
    }) => name)) !== null && _savedSearchData$$doc !== void 0 ? _savedSearchData$$doc : []
  });

  /**
   * Data fetching
   */

  const skipRefetch = (0, _react.useRef)();

  // Skip refetching when showing the chart since Lens will
  // automatically fetch when the chart is shown
  (0, _react.useEffect)(() => {
    if (skipRefetch.current === undefined) {
      skipRefetch.current = false;
    } else {
      skipRefetch.current = !hideChart;
    }
  }, [hideChart]);

  // Handle unified histogram refetching
  (0, _react.useEffect)(() => {
    if (!unifiedHistogram) {
      return;
    }
    let fetch$;

    // When in text based language mode, we refetch under two conditions:
    // 1. When the current Lens suggestion changes. This syncs the visualization
    //    with the user's selection.
    // 2. When the documents are done fetching. This is necessary because we don't
    //    have access to the latest columns until after the documents are fetched,
    //    which are required to get the latest Lens suggestion, which would trigger
    //    a refetch anyway and result in multiple unnecessary fetches.
    if (isPlainRecord) {
      fetch$ = (0, _rxjs.merge)(createCurrentSuggestionObservable(unifiedHistogram.state$).pipe((0, _rxjs.map)(() => 'lens')), textBasedFetchComplete$.pipe((0, _rxjs.map)(() => 'discover'))).pipe((0, _rxjs.debounceTime)(50));
    } else {
      fetch$ = stateContainer.dataState.fetch$.pipe((0, _rxjs.map)(() => 'discover'));
    }
    const subscription = fetch$.subscribe(source => {
      if (!skipRefetch.current) {
        if (source === 'discover') (0, _add_log.addLog)('Unified Histogram - Discover refetch');
        if (source === 'lens') (0, _add_log.addLog)('Unified Histogram - Lens suggestion refetch');
        unifiedHistogram.refetch();
      }
      skipRefetch.current = false;
    });
    return () => {
      subscription.unsubscribe();
    };
  }, [isPlainRecord, stateContainer.dataState.fetch$, textBasedFetchComplete$, unifiedHistogram]);
  const dataView = (0, _discover_internal_state_container.useInternalStateSelector)(state => state.dataView);
  return {
    ref,
    getCreationOptions,
    services: {
      ...services,
      uiActions: (0, _kibana_services.getUiActions)()
    },
    dataView: isPlainRecord ? textBasedDataView : dataView,
    query: isPlainRecord ? textBasedQuery : query,
    filters,
    timeRange,
    relativeTimeRange,
    columns
  };
};

// Use pairwise to diff the previous and current state (starting with undefined to ensure
// pairwise triggers after a single emission), and return an object containing only the
// changed properties. By only including the changed properties, we avoid accidentally
// overwriting other state properties that may have been updated between the time this
// obersverable was triggered and the time the state changes are applied.
exports.useDiscoverHistogram = useDiscoverHistogram;
const createUnifiedHistogramStateObservable = state$ => {
  return state$ === null || state$ === void 0 ? void 0 : state$.pipe((0, _rxjs.startWith)(undefined), (0, _rxjs.pairwise)(), (0, _rxjs.map)(([prev, curr]) => {
    const changes = {};
    if (!curr) {
      return changes;
    }
    if ((prev === null || prev === void 0 ? void 0 : prev.lensRequestAdapter) !== curr.lensRequestAdapter) {
      changes.lensRequestAdapter = curr.lensRequestAdapter;
    }
    if ((prev === null || prev === void 0 ? void 0 : prev.chartHidden) !== curr.chartHidden) {
      changes.hideChart = curr.chartHidden;
    }
    if ((prev === null || prev === void 0 ? void 0 : prev.timeInterval) !== curr.timeInterval) {
      changes.interval = curr.timeInterval;
    }
    if ((prev === null || prev === void 0 ? void 0 : prev.breakdownField) !== curr.breakdownField) {
      changes.breakdownField = curr.breakdownField;
    }
    return changes;
  }), (0, _rxjs.filter)(changes => Object.keys(changes).length > 0));
};
const createAppStateObservable = state$ => {
  return state$.pipe((0, _rxjs.startWith)(undefined), (0, _rxjs.pairwise)(), (0, _rxjs.map)(([prev, curr]) => {
    const changes = {};
    if (!curr) {
      return changes;
    }
    if ((prev === null || prev === void 0 ? void 0 : prev.breakdownField) !== curr.breakdownField) {
      changes.breakdownField = curr.breakdownField;
    }
    if ((prev === null || prev === void 0 ? void 0 : prev.interval) !== curr.interval) {
      changes.timeInterval = curr.interval;
    }
    if ((prev === null || prev === void 0 ? void 0 : prev.hideChart) !== curr.hideChart) {
      changes.chartHidden = curr.hideChart;
    }
    return changes;
  }), (0, _rxjs.filter)(changes => Object.keys(changes).length > 0));
};
const createFetchCompleteObservable = stateContainer => {
  return stateContainer.dataState.data$.documents$.pipe((0, _rxjs.distinctUntilChanged)((prev, curr) => prev.fetchStatus === curr.fetchStatus), (0, _rxjs.filter)(({
    fetchStatus
  }) => fetchStatus === _types.FetchStatus.COMPLETE), (0, _rxjs.map)(({
    textBasedQueryColumns
  }) => {
    var _textBasedQueryColumn;
    return {
      dataView: stateContainer.internalState.getState().dataView,
      query: stateContainer.appState.getState().query,
      columns: (_textBasedQueryColumn = textBasedQueryColumns === null || textBasedQueryColumns === void 0 ? void 0 : textBasedQueryColumns.map(({
        name
      }) => name)) !== null && _textBasedQueryColumn !== void 0 ? _textBasedQueryColumn : []
    };
  }));
};
const createTotalHitsObservable = state$ => {
  return state$ === null || state$ === void 0 ? void 0 : state$.pipe((0, _rxjs.map)(state => ({
    status: state.totalHitsStatus,
    result: state.totalHitsResult
  })), (0, _rxjs.distinctUntilChanged)((prev, curr) => prev.status === curr.status && prev.result === curr.result));
};
const createCurrentSuggestionObservable = state$ => {
  return state$.pipe((0, _rxjs.map)(state => state.currentSuggestion), (0, _rxjs.distinctUntilChanged)(_lodash.isEqual));
};