"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverMainContent = void 0;
var _eui = require("@elastic/eui");
var _domDragDrop = require("@kbn/dom-drag-drop");
var _react = _interopRequireWildcard(require("react"));
var _analytics = require("@kbn/analytics");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../common/constants");
var _use_discover_services = require("../../../../hooks/use_discover_services");
var _view_mode_toggle = require("../../../../components/view_mode_toggle");
var _field_stats_table = require("../field_stats_table");
var _discover_documents = require("./discover_documents");
var _constants2 = require("../field_stats_table/constants");
var _error_callout = require("../../../../components/common/error_callout");
var _use_data_state = require("../../hooks/use_data_state");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DROP_PROPS = {
  value: {
    id: 'dscDropZoneTable',
    humanData: {
      label: _i18n.i18n.translate('discover.dropZoneTableLabel', {
        defaultMessage: 'Drop zone to add field as a column to the table'
      })
    }
  },
  order: [1, 0, 0, 0],
  types: ['field_add']
};
const DiscoverMainContent = ({
  dataView,
  isPlainRecord,
  viewMode,
  onAddFilter,
  onFieldEdited,
  columns,
  stateContainer,
  onDropFieldToTable
}) => {
  const {
    trackUiMetric
  } = (0, _use_discover_services.useDiscoverServices)();
  const setDiscoverViewMode = (0, _react.useCallback)(mode => {
    stateContainer.appState.update({
      viewMode: mode
    });
    if (trackUiMetric) {
      if (mode === _constants.VIEW_MODE.AGGREGATED_LEVEL) {
        trackUiMetric(_analytics.METRIC_TYPE.CLICK, _constants2.FIELD_STATISTICS_VIEW_CLICK);
      } else {
        trackUiMetric(_analytics.METRIC_TYPE.CLICK, _constants2.DOCUMENTS_VIEW_CLICK);
      }
    }
  }, [trackUiMetric, stateContainer]);
  const dataState = (0, _use_data_state.useDataState)(stateContainer.dataState.data$.main$);
  const isDropAllowed = Boolean(onDropFieldToTable);
  return /*#__PURE__*/_react.default.createElement(_domDragDrop.DragDrop, {
    draggable: false,
    dropTypes: isDropAllowed ? DROP_PROPS.types : undefined,
    value: DROP_PROPS.value,
    order: DROP_PROPS.order,
    onDrop: onDropFieldToTable
  }, /*#__PURE__*/_react.default.createElement(_domDragDrop.DropOverlayWrapper, {
    isVisible: isDropAllowed
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "eui-fullHeight",
    direction: "column",
    gutterSize: "none",
    responsive: false,
    "data-test-subj": "dscMainContent"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), !isPlainRecord && /*#__PURE__*/_react.default.createElement(_view_mode_toggle.DocumentViewModeToggle, {
    viewMode: viewMode,
    setDiscoverViewMode: setDiscoverViewMode
  })), dataState.error && /*#__PURE__*/_react.default.createElement(_error_callout.ErrorCallout, {
    title: _i18n.i18n.translate('discover.documentsErrorTitle', {
      defaultMessage: 'Search error'
    }),
    error: dataState.error,
    inline: true,
    "data-test-subj": "discoverMainError"
  }), viewMode === _constants.VIEW_MODE.DOCUMENT_LEVEL ? /*#__PURE__*/_react.default.createElement(_discover_documents.DiscoverDocuments, {
    dataView: dataView,
    onAddFilter: !isPlainRecord ? onAddFilter : undefined,
    stateContainer: stateContainer,
    onFieldEdited: !isPlainRecord ? onFieldEdited : undefined
  }) : /*#__PURE__*/_react.default.createElement(_field_stats_table.FieldStatisticsTab, {
    dataView: dataView,
    columns: columns,
    stateContainer: stateContainer,
    onAddFilter: !isPlainRecord ? onAddFilter : undefined,
    trackUiMetric: trackUiMetric
  }))));
};
exports.DiscoverMainContent = DiscoverMainContent;