"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEsQuerySearchAfter = getEsQuerySearchAfter;
var _context = require("../services/context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Get the searchAfter query value for elasticsearch
 * When there are already documents available, which means successors or predecessors
 * were already fetched, the new searchAfter for the next fetch has to be the sort value
 * of the first (prececessor), or last (successor) of the list
 */
function getEsQuerySearchAfter(type, documents, timeFieldName, anchor, nanoSeconds, useNewFieldsApi) {
  var _anchor$raw$sort, _anchor$raw$sort2;
  if (documents.length) {
    var _afterTimeDocRaw$sort, _afterTimeDoc$raw$sor;
    // already surrounding docs -> first or last record  is used
    const afterTimeRecIdx = type === _context.SurrDocType.SUCCESSORS && documents.length ? documents.length - 1 : 0;
    const afterTimeDoc = documents[afterTimeRecIdx];
    const afterTimeDocRaw = afterTimeDoc.raw;
    let afterTimeValue = (_afterTimeDocRaw$sort = afterTimeDocRaw.sort) === null || _afterTimeDocRaw$sort === void 0 ? void 0 : _afterTimeDocRaw$sort[0];
    if (nanoSeconds) {
      var _afterTimeDocRaw$fiel, _afterTimeDocRaw$_sou;
      afterTimeValue = useNewFieldsApi ? (_afterTimeDocRaw$fiel = afterTimeDocRaw.fields) === null || _afterTimeDocRaw$fiel === void 0 ? void 0 : _afterTimeDocRaw$fiel[timeFieldName][0] : (_afterTimeDocRaw$_sou = afterTimeDocRaw._source) === null || _afterTimeDocRaw$_sou === void 0 ? void 0 : _afterTimeDocRaw$_sou[timeFieldName];
    }
    return [afterTimeValue, (_afterTimeDoc$raw$sor = afterTimeDoc.raw.sort) === null || _afterTimeDoc$raw$sor === void 0 ? void 0 : _afterTimeDoc$raw$sor[1]];
  }
  // if data_nanos adapt timestamp value for sorting, since numeric value was rounded by browser
  // ES search_after also works when number is provided as string
  const searchAfter = new Array(2);
  searchAfter[0] = (_anchor$raw$sort = anchor.raw.sort) === null || _anchor$raw$sort === void 0 ? void 0 : _anchor$raw$sort[0];
  if (nanoSeconds) {
    var _anchor$raw$fields, _anchor$raw$_source;
    searchAfter[0] = useNewFieldsApi ? (_anchor$raw$fields = anchor.raw.fields) === null || _anchor$raw$fields === void 0 ? void 0 : _anchor$raw$fields[timeFieldName][0] : (_anchor$raw$_source = anchor.raw._source) === null || _anchor$raw$_source === void 0 ? void 0 : _anchor$raw$_source[timeFieldName];
  }
  searchAfter[1] = (_anchor$raw$sort2 = anchor.raw.sort) === null || _anchor$raw$sort2 === void 0 ? void 0 : _anchor$raw$sort2[1];
  return searchAfter;
}