"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverContextAppLocatorDefinition = exports.DISCOVER_CONTEXT_APP_LOCATOR = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/kibana-utils-plugin/public");
var _customizations = require("../../../../common/customizations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const DISCOVER_CONTEXT_APP_LOCATOR = 'DISCOVER_CONTEXT_APP_LOCATOR';
exports.DISCOVER_CONTEXT_APP_LOCATOR = DISCOVER_CONTEXT_APP_LOCATOR;
class DiscoverContextAppLocatorDefinition {
  constructor(deps) {
    (0, _defineProperty2.default)(this, "id", DISCOVER_CONTEXT_APP_LOCATOR);
    (0, _defineProperty2.default)(this, "getLocation", async params => {
      const useHash = this.deps.useHash;
      const {
        index,
        rowId,
        columns,
        filters,
        referrer
      } = params;
      const appState = {};
      const queryState = {};
      const {
        isFilterPinned
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/es-query')));
      if (filters && filters.length) appState.filters = filters === null || filters === void 0 ? void 0 : filters.filter(f => !isFilterPinned(f));
      if (columns) appState.columns = columns;
      if (filters && filters.length) queryState.filters = filters === null || filters === void 0 ? void 0 : filters.filter(f => isFilterPinned(f));
      let dataViewId;
      const state = {
        referrer
      };
      if (typeof index === 'object') {
        state.dataViewSpec = index;
        dataViewId = index.id;
      } else {
        dataViewId = index;
      }
      let path = '#/';
      if (params.profile) {
        path = (0, _customizations.addProfile)(path, params.profile);
      }
      path = `${path}context/${dataViewId}/${rowId}`;
      if (Object.keys(queryState).length) {
        path = (0, _public.setStateToKbnUrl)('_g', queryState, {
          useHash
        }, path);
      }
      if (Object.keys(appState).length) {
        path = (0, _public.setStateToKbnUrl)('_a', appState, {
          useHash
        }, path);
      }
      return {
        app: 'discover',
        path,
        state
      };
    });
    this.deps = deps;
  }
}
exports.DiscoverContextAppLocatorDefinition = DiscoverContextAppLocatorDefinition;