"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AbstractExploreDataAction = exports.ACTION_EXPLORE_DATA = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/embeddable-plugin/public");
var _constants = require("@kbn/lens-plugin/common/constants");
var shared = _interopRequireWildcard(require("./shared"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ACTION_EXPLORE_DATA = 'ACTION_EXPLORE_DATA';
exports.ACTION_EXPLORE_DATA = ACTION_EXPLORE_DATA;
class AbstractExploreDataAction {
  constructor(params) {
    (0, _defineProperty2.default)(this, "getIconType", context => 'discoverApp');
    (0, _defineProperty2.default)(this, "getDisplayName", context => _i18n.i18n.translate('xpack.discover.FlyoutCreateDrilldownAction.displayName', {
      defaultMessage: 'Explore underlying data'
    }));
    this.params = params;
  }
  async isCompatible({
    embeddable
  }) {
    if (!embeddable) return false;
    if (embeddable.type === _constants.DOC_TYPE) return false;
    const {
      core,
      plugins
    } = this.params.start();
    const {
      capabilities
    } = core.application;
    if (capabilities.discover && !capabilities.discover.show) return false;
    if (!plugins.discover.locator) return false;
    if (!shared.hasExactlyOneIndexPattern(embeddable)) return false;
    if (embeddable.getInput().viewMode !== _public.ViewMode.VIEW) return false;
    return true;
  }
  async execute(context) {
    if (!shared.hasExactlyOneIndexPattern(context.embeddable)) return;
    const {
      core
    } = this.params.start();
    const {
      app,
      path
    } = await this.getLocation(context);
    await core.application.navigateToApp(app, {
      path
    });
  }
  async getHref(context) {
    const {
      embeddable
    } = context;
    if (!shared.hasExactlyOneIndexPattern(embeddable)) {
      throw new Error(`Embeddable not supported for "${this.getDisplayName(context)}" action.`);
    }
    const {
      core
    } = this.params.start();
    const {
      app,
      path
    } = await this.getLocation(context);
    const url = await core.application.getUrlForApp(app, {
      path,
      absolute: false
    });
    return url;
  }
}
exports.AbstractExploreDataAction = AbstractExploreDataAction;