"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BreadcrumbService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _texts = require("../constants/texts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class BreadcrumbService {
  constructor() {
    (0, _defineProperty2.default)(this, "setBreadcrumbsHandler", void 0);
  }
  setup(setBreadcrumbsHandler) {
    this.setBreadcrumbsHandler = setBreadcrumbsHandler;
  }
  setBreadcrumbs(page) {
    if (!this.setBreadcrumbsHandler) {
      throw new Error('Breadcrumb service has not been initialized');
    }
    if (!page || page === 'home') {
      this.setBreadcrumbsHandler([{
        text: _texts.i18Texts.breadcrumbs.home
      }]);
    } else {
      this.setBreadcrumbsHandler([{
        text: _texts.i18Texts.breadcrumbs.home,
        href: '#/'
      }, {
        text: page
      }]);
    }
  }
}
exports.BreadcrumbService = BreadcrumbService;