"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataVisualizerGridData = void 0;
var _react = require("react");
var _rxjs = require("rxjs");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/data-plugin/common");
var _fieldTypes = require("@kbn/field-types");
var _seedrandom = _interopRequireDefault(require("seedrandom"));
var _mlDatePicker = require("@kbn/ml-date-picker");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _public = require("@kbn/kibana-react-plugin/public");
var _constants = require("../embeddables/grid_embeddable/constants");
var _filter_fields = require("../../common/components/fields_stats_grid/filter_fields");
var _kibana_context = require("../../kibana_context");
var _saved_search_utils = require("../utils/saved_search_utils");
var _time_buckets = require("../../../../common/services/time_buckets");
var _constants2 = require("../../../../common/constants");
var _field_types_utils = require("../../common/util/field_types_utils");
var _action_menu = require("../../common/components/field_data_row/action_menu");
var _index_data_visualizer_view = require("../components/index_data_visualizer_view/index_data_visualizer_view");
var _use_field_stats = require("./use_field_stats");
var _use_overall_stats = require("./use_overall_stats");
var _get_supported_aggs = require("../utils/get_supported_aggs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaults = (0, _index_data_visualizer_view.getDefaultPageState)();
function isDisplayField(fieldName) {
  return !_constants2.OMIT_FIELDS.includes(fieldName);
}
const DEFAULT_SAMPLING_OPTION = {
  mode: 'random_sampling',
  seed: '',
  probability: 0
};
const useDataVisualizerGridData = (input, dataVisualizerListState, savedRandomSamplerPreference, onUpdate) => {
  var _overallStats$documen2;
  const {
    services
  } = (0, _kibana_context.useDataVisualizerKibana)();
  const {
    uiSettings,
    data,
    security,
    executionContext
  } = services;
  const parentExecutionContext = (0, _useObservable.default)(executionContext === null || executionContext === void 0 ? void 0 : executionContext.context$);
  const embeddableExecutionContext = (0, _react.useMemo)(() => {
    const child = {
      type: 'visualization',
      name: _constants.DATA_VISUALIZER_GRID_EMBEDDABLE_TYPE,
      id: input.id
    };
    return {
      ...(parentExecutionContext ? parentExecutionContext : {}),
      child
    };
  }, [parentExecutionContext, input.id]);
  (0, _public.useExecutionContext)(executionContext, embeddableExecutionContext);
  const {
    samplerShardSize,
    visibleFieldTypes,
    showEmptyFields
  } = dataVisualizerListState;
  const [lastRefresh, setLastRefresh] = (0, _react.useState)(0);
  const searchSessionId = input.sessionId;
  const browserSessionSeed = (0, _react.useMemo)(() => {
    let seed = Math.abs((0, _seedrandom.default)().int32());
    if (security !== undefined) {
      security.authc.getCurrentUser().then(user => {
        const username = user.username;
        if (username) {
          seed = Math.abs((0, _seedrandom.default)(username).int32());
        }
      });
    }
    return seed;
  }, [security]);
  const {
    currentSavedSearch,
    currentDataView,
    currentQuery,
    currentFilters,
    visibleFieldNames,
    fieldsToFetch,
    samplingOption
  } = (0, _react.useMemo)(() => {
    var _input$visibleFieldNa, _input$samplingOption;
    return {
      currentSavedSearch: input === null || input === void 0 ? void 0 : input.savedSearch,
      currentDataView: input.dataView,
      currentQuery: input === null || input === void 0 ? void 0 : input.query,
      visibleFieldNames: (_input$visibleFieldNa = input === null || input === void 0 ? void 0 : input.visibleFieldNames) !== null && _input$visibleFieldNa !== void 0 ? _input$visibleFieldNa : [],
      currentFilters: input === null || input === void 0 ? void 0 : input.filters,
      fieldsToFetch: input === null || input === void 0 ? void 0 : input.fieldsToFetch,
      /** By default, use random sampling **/
      samplingOption: (_input$samplingOption = input === null || input === void 0 ? void 0 : input.samplingOption) !== null && _input$samplingOption !== void 0 ? _input$samplingOption : DEFAULT_SAMPLING_OPTION
    };
  }, [input]);

  /** Prepare required params to pass to search strategy **/
  const {
    searchQueryLanguage,
    searchString,
    searchQuery,
    queryOrAggregateQuery
  } = (0, _react.useMemo)(() => {
    const filterManager = data.query.filterManager;
    const searchData = (0, _saved_search_utils.getEsQueryFromSavedSearch)({
      dataView: currentDataView,
      uiSettings,
      savedSearch: currentSavedSearch,
      query: currentQuery,
      filters: currentFilters,
      filterManager: data.query.filterManager
    });
    if (searchData === undefined || dataVisualizerListState.searchString !== '') {
      if (dataVisualizerListState.filters) {
        const globalFilters = filterManager === null || filterManager === void 0 ? void 0 : filterManager.getGlobalFilters();
        if (filterManager) filterManager.setFilters(dataVisualizerListState.filters);
        if (globalFilters) filterManager === null || filterManager === void 0 ? void 0 : filterManager.addFilters(globalFilters);
      }
      return {
        searchQuery: dataVisualizerListState.searchQuery,
        searchString: dataVisualizerListState.searchString,
        searchQueryLanguage: dataVisualizerListState.searchQueryLanguage
      };
    } else {
      return {
        queryOrAggregateQuery: searchData.queryOrAggregateQuery,
        searchQuery: searchData.searchQuery,
        searchString: searchData.searchString,
        searchQueryLanguage: searchData.queryLanguage
      };
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [currentSavedSearch === null || currentSavedSearch === void 0 ? void 0 : currentSavedSearch.id, currentDataView.id, dataVisualizerListState.searchString, dataVisualizerListState.searchQueryLanguage,
  // eslint-disable-next-line react-hooks/exhaustive-deps
  JSON.stringify({
    searchQuery: dataVisualizerListState.searchQuery,
    currentQuery,
    currentFilters
  }), lastRefresh]);
  const _timeBuckets = (0, _react.useMemo)(() => {
    return new _time_buckets.TimeBuckets({
      [_common.UI_SETTINGS.HISTOGRAM_MAX_BARS]: uiSettings.get(_common.UI_SETTINGS.HISTOGRAM_MAX_BARS),
      [_common.UI_SETTINGS.HISTOGRAM_BAR_TARGET]: uiSettings.get(_common.UI_SETTINGS.HISTOGRAM_BAR_TARGET),
      dateFormat: uiSettings.get('dateFormat'),
      'dateFormat:scaled': uiSettings.get('dateFormat:scaled')
    });
  }, [uiSettings]);
  const timefilter = (0, _mlDatePicker.useTimefilter)({
    timeRangeSelector: (currentDataView === null || currentDataView === void 0 ? void 0 : currentDataView.timeFieldName) !== undefined,
    autoRefreshSelector: true
  });
  const [metricConfigs, setMetricConfigs] = (0, _react.useState)(defaults.metricConfigs);
  const [metricsLoaded, setMetricsLoaded] = (0, _react.useState)(defaults.metricsLoaded);
  const [metricsStats, setMetricsStats] = (0, _react.useState)();
  const [nonMetricConfigs, setNonMetricConfigs] = (0, _react.useState)(defaults.nonMetricConfigs);
  const [nonMetricsLoaded, setNonMetricsLoaded] = (0, _react.useState)(defaults.nonMetricsLoaded);

  /** Search strategy **/
  const fieldStatsRequest = (0, _react.useMemo)(() => {
    // Obtain the interval to use for date histogram aggregations
    // (such as the document count chart). Aim for 75 bars.
    const buckets = _timeBuckets;
    const tf = timefilter;
    if (!buckets || !tf || !currentDataView) return;
    const activeBounds = tf.getActiveBounds();
    let earliest;
    let latest;
    if (activeBounds !== undefined && currentDataView.timeFieldName !== undefined) {
      var _activeBounds$min, _activeBounds$max;
      earliest = (_activeBounds$min = activeBounds.min) === null || _activeBounds$min === void 0 ? void 0 : _activeBounds$min.valueOf();
      latest = (_activeBounds$max = activeBounds.max) === null || _activeBounds$max === void 0 ? void 0 : _activeBounds$max.valueOf();
    }
    const bounds = tf.getActiveBounds();
    const BAR_TARGET = 75;
    buckets.setInterval('auto');
    if (bounds) {
      buckets.setBounds(bounds);
      buckets.setBarTarget(BAR_TARGET);
    }
    const aggInterval = buckets.getInterval();
    const aggregatableFields = [];
    const nonAggregatableFields = [];
    const fields = currentDataView.fields;
    fields === null || fields === void 0 ? void 0 : fields.forEach(field => {
      if (fieldsToFetch && !fieldsToFetch.includes(field.name)) {
        return;
      }
      const fieldName = field.displayName !== undefined ? field.displayName : field.name;
      if (!_constants2.OMIT_FIELDS.includes(fieldName)) {
        var _field$esTypes;
        if (field.aggregatable === true && !_constants2.NON_AGGREGATABLE_FIELD_TYPES.has(field.type) && !((_field$esTypes = field.esTypes) !== null && _field$esTypes !== void 0 && _field$esTypes.some(d => d === _fieldTypes.ES_FIELD_TYPES.AGGREGATE_METRIC_DOUBLE))) {
          aggregatableFields.push({
            name: field.name,
            supportedAggs: (0, _get_supported_aggs.getSupportedAggs)(field)
          });
        } else {
          nonAggregatableFields.push(field.name);
        }
      }
    });
    return {
      earliest,
      latest,
      aggInterval,
      intervalMs: aggInterval === null || aggInterval === void 0 ? void 0 : aggInterval.asMilliseconds(),
      searchQuery,
      samplerShardSize,
      sessionId: searchSessionId,
      index: currentDataView.title,
      timeFieldName: currentDataView.timeFieldName,
      runtimeFieldMap: currentDataView.getRuntimeMappings(),
      aggregatableFields,
      nonAggregatableFields,
      fieldsToFetch,
      browserSessionSeed,
      samplingOption: {
        ...samplingOption,
        seed: browserSessionSeed.toString()
      },
      embeddableExecutionContext
    };
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [_timeBuckets, timefilter, currentDataView.id,
  // eslint-disable-next-line react-hooks/exhaustive-deps
  JSON.stringify(searchQuery),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  JSON.stringify(samplingOption), samplerShardSize, searchSessionId, lastRefresh, fieldsToFetch, browserSessionSeed, embeddableExecutionContext]);
  const {
    overallStats,
    progress: overallStatsProgress
  } = (0, _use_overall_stats.useOverallStats)(fieldStatsRequest, lastRefresh, dataVisualizerListState.probability);
  const configsWithoutStats = (0, _react.useMemo)(() => {
    if (overallStatsProgress.loaded < 100) return;
    const existMetricFields = metricConfigs.map(config => {
      var _config$stats;
      return {
        ...config,
        cardinality: (_config$stats = config.stats) === null || _config$stats === void 0 ? void 0 : _config$stats.cardinality
      };
    }).filter(c => c !== undefined);

    // Pass the field name, type and cardinality in the request.
    // Top values will be obtained on a sample if cardinality > 100000.
    const existNonMetricFields = nonMetricConfigs.map(config => {
      var _config$stats2;
      return {
        ...config,
        cardinality: (_config$stats2 = config.stats) === null || _config$stats2 === void 0 ? void 0 : _config$stats2.cardinality
      };
    }).filter(c => c !== undefined);
    return {
      metricConfigs: existMetricFields,
      nonMetricConfigs: existNonMetricFields
    };
  }, [metricConfigs, nonMetricConfigs, overallStatsProgress.loaded]);
  const probability = (0, _react.useMemo)(() => {
    var _ref, _overallStats$documen;
    return (// If random sampler probability is already manually selected, or is available from the URL
      // use that instead of using the probability calculated from the doc count
      (_ref = dataVisualizerListState.probability === null ? overallStats === null || overallStats === void 0 ? void 0 : (_overallStats$documen = overallStats.documentCountStats) === null || _overallStats$documen === void 0 ? void 0 : _overallStats$documen.probability : dataVisualizerListState.probability) !== null && _ref !== void 0 ? _ref : 1
    );
  }, [dataVisualizerListState.probability, overallStats === null || overallStats === void 0 ? void 0 : (_overallStats$documen2 = overallStats.documentCountStats) === null || _overallStats$documen2 === void 0 ? void 0 : _overallStats$documen2.probability]);
  const strategyResponse = (0, _use_field_stats.useFieldStatsSearchStrategy)(fieldStatsRequest, configsWithoutStats, dataVisualizerListState, probability);
  const combinedProgress = (0, _react.useMemo)(() => overallStatsProgress.loaded * 0.2 + strategyResponse.progress.loaded * 0.8, [overallStatsProgress.loaded, strategyResponse.progress.loaded]);
  (0, _react.useEffect)(() => {
    const timeUpdateSubscription = (0, _rxjs.merge)(timefilter.getTimeUpdate$(), timefilter.getAutoRefreshFetch$(), _mlDatePicker.mlTimefilterRefresh$).subscribe(() => {
      if (onUpdate) {
        onUpdate({
          time: timefilter.getTime(),
          refreshInterval: timefilter.getRefreshInterval()
        });
      }
      setLastRefresh(Date.now());
    });
    return () => {
      timeUpdateSubscription.unsubscribe();
    };
  });
  const dataViewFields = (0, _react.useMemo)(() => currentDataView.fields, [currentDataView]);
  const createMetricCards = (0, _react.useCallback)(() => {
    const configs = [];
    const aggregatableExistsFields = overallStats.aggregatableExistsFields || [];
    const allMetricFields = dataViewFields.filter(f => {
      return f.type === _fieldTypes.KBN_FIELD_TYPES.NUMBER && f.displayName !== undefined && isDisplayField(f.displayName) === true;
    });
    const metricExistsFields = allMetricFields.filter(f => {
      return aggregatableExistsFields.find(existsF => {
        return existsF.fieldName === f.spec.name;
      });
    });
    if (metricsLoaded === false) {
      setMetricsLoaded(true);
      return;
    }
    let aggregatableFields = overallStats.aggregatableExistsFields;
    if (allMetricFields.length !== metricExistsFields.length && metricsLoaded === true) {
      aggregatableFields = aggregatableFields.concat(overallStats.aggregatableNotExistsFields);
    }
    const metricFieldsToShow = metricsLoaded === true && showEmptyFields === true ? allMetricFields : metricExistsFields;
    metricFieldsToShow.forEach(field => {
      var _fieldData$existsInDo;
      const fieldData = aggregatableFields.find(f => {
        return f.fieldName === field.spec.name;
      });
      if (!fieldData) return;
      const metricConfig = {
        ...fieldData,
        fieldFormat: currentDataView.getFormatterForField(field),
        type: _constants2.SUPPORTED_FIELD_TYPES.NUMBER,
        secondaryType: (0, _field_types_utils.kbnTypeToSupportedType)(field),
        loading: (_fieldData$existsInDo = fieldData === null || fieldData === void 0 ? void 0 : fieldData.existsInDocs) !== null && _fieldData$existsInDo !== void 0 ? _fieldData$existsInDo : true,
        aggregatable: true,
        deletable: field.runtimeField !== undefined,
        supportedAggs: (0, _get_supported_aggs.getSupportedAggs)(field)
      };
      if (field.displayName !== metricConfig.fieldName) {
        metricConfig.displayName = field.displayName;
      }
      configs.push(metricConfig);
    });
    setMetricsStats({
      totalMetricFieldsCount: allMetricFields.length,
      visibleMetricsCount: metricFieldsToShow.length
    });
    setMetricConfigs(configs);
  }, [currentDataView, dataViewFields, metricsLoaded, overallStats, showEmptyFields]);
  const createNonMetricCards = (0, _react.useCallback)(() => {
    const allNonMetricFields = dataViewFields.filter(f => {
      return f.type !== _fieldTypes.KBN_FIELD_TYPES.NUMBER && f.displayName !== undefined && isDisplayField(f.displayName) === true;
    });
    // Obtain the list of all non-metric fields which appear in documents
    // (aggregatable or not aggregatable).
    const populatedNonMetricFields = []; // Kibana index pattern non metric fields.
    let nonMetricFieldData = []; // Basic non metric field data loaded from requesting overall stats.
    const aggregatableExistsFields = overallStats.aggregatableExistsFields || [];
    const nonAggregatableExistsFields = overallStats.nonAggregatableExistsFields || [];
    allNonMetricFields.forEach(f => {
      const checkAggregatableField = aggregatableExistsFields.find(existsField => existsField.fieldName === f.spec.name);
      if (checkAggregatableField !== undefined) {
        populatedNonMetricFields.push(f);
        nonMetricFieldData.push(checkAggregatableField);
      } else {
        const checkNonAggregatableField = nonAggregatableExistsFields.find(existsField => existsField.fieldName === f.spec.name);
        if (checkNonAggregatableField !== undefined) {
          populatedNonMetricFields.push(f);
          nonMetricFieldData.push(checkNonAggregatableField);
        }
      }
    });
    if (nonMetricsLoaded === false) {
      setNonMetricsLoaded(true);
      return;
    }
    if (allNonMetricFields.length !== nonMetricFieldData.length && showEmptyFields === true) {
      // Combine the field data obtained from Elasticsearch into a single array.
      nonMetricFieldData = nonMetricFieldData.concat(overallStats.aggregatableNotExistsFields, overallStats.nonAggregatableNotExistsFields);
    }
    const nonMetricFieldsToShow = showEmptyFields ? allNonMetricFields : populatedNonMetricFields;
    const configs = [];
    nonMetricFieldsToShow.forEach(field => {
      var _fieldData$existsInDo2;
      const fieldData = nonMetricFieldData.find(f => f.fieldName === field.spec.name);
      const nonMetricConfig = {
        ...(fieldData ? fieldData : {}),
        secondaryType: (0, _field_types_utils.kbnTypeToSupportedType)(field),
        fieldFormat: currentDataView.getFormatterForField(field),
        aggregatable: field.aggregatable,
        loading: (_fieldData$existsInDo2 = fieldData === null || fieldData === void 0 ? void 0 : fieldData.existsInDocs) !== null && _fieldData$existsInDo2 !== void 0 ? _fieldData$existsInDo2 : true,
        deletable: field.runtimeField !== undefined
      };

      // Map the field type from the Kibana index pattern to the field type
      // used in the data visualizer.
      const dataVisualizerType = (0, _field_types_utils.kbnTypeToSupportedType)(field);
      if (dataVisualizerType !== undefined) {
        nonMetricConfig.type = dataVisualizerType;
      } else {
        // Add a flag to indicate that this is one of the 'other' Kibana
        // field types that do not yet have a specific card type.
        nonMetricConfig.type = field.type;
        nonMetricConfig.isUnsupportedType = true;
      }
      if (field.displayName !== nonMetricConfig.fieldName) {
        nonMetricConfig.displayName = field.displayName;
      }
      configs.push(nonMetricConfig);
    });
    setNonMetricConfigs(configs);
  }, [currentDataView, dataViewFields, nonMetricsLoaded, overallStats, showEmptyFields]);
  (0, _react.useEffect)(() => {
    createMetricCards();
    createNonMetricCards();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [overallStats, showEmptyFields]);
  const configs = (0, _react.useMemo)(() => {
    const fieldStats = strategyResponse.fieldStats;
    let combinedConfigs = [...nonMetricConfigs, ...metricConfigs];
    combinedConfigs = (0, _filter_fields.filterFields)(combinedConfigs, visibleFieldNames, visibleFieldTypes).filteredFields;
    if (fieldStats) {
      combinedConfigs = combinedConfigs.map(c => {
        var _fieldStats$get;
        const loadedFullStats = (_fieldStats$get = fieldStats.get(c.fieldName)) !== null && _fieldStats$get !== void 0 ? _fieldStats$get : {};
        return loadedFullStats ? {
          ...c,
          loading: false,
          stats: {
            ...c.stats,
            ...loadedFullStats
          }
        } : c;
      });
    }
    return combinedConfigs;
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [nonMetricConfigs, metricConfigs, visibleFieldTypes, visibleFieldNames, strategyResponse.progress.loaded, dataVisualizerListState.pageIndex, dataVisualizerListState.pageSize]);

  // Some actions open up fly-out or popup
  // This variable is used to keep track of them and clean up when unmounting
  const actionFlyoutRef = (0, _react.useRef)();
  (0, _react.useEffect)(() => {
    const ref = actionFlyoutRef;
    return () => {
      // Clean up any of the flyout/editor opened from the actions
      if (ref.current) {
        ref.current();
      }
    };
  }, []);

  // Inject custom action column for the index based visualizer
  // Hide the column completely if no access to any of the plugins
  const extendedColumns = (0, _react.useMemo)(() => {
    const actions = (0, _action_menu.getActions)(input.dataView, services, {
      searchQueryLanguage,
      searchString
    }, input.allowEditDataView ? actionFlyoutRef : undefined);
    if (!Array.isArray(actions) || actions.length < 1) return;
    const actionColumn = {
      name: _i18n.i18n.translate('xpack.dataVisualizer.index.dataGrid.actionsColumnLabel', {
        defaultMessage: 'Actions'
      }),
      actions,
      width: '70px'
    };
    return [actionColumn];
  }, [input.dataView, services, searchQueryLanguage, searchString, input.allowEditDataView]);
  return {
    progress: combinedProgress,
    overallStatsProgress,
    configs,
    queryOrAggregateQuery,
    searchQueryLanguage,
    searchString,
    searchQuery,
    extendedColumns,
    documentCountStats: overallStats.documentCountStats,
    metricsStats,
    overallStats,
    timefilter,
    setLastRefresh
  };
};
exports.useDataVisualizerGridData = useDataVisualizerGridData;