"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataViewsApiClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lib = require("../../common/lib");
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const API_BASE_URL = `/api/index_patterns/`;
const version = '1';

/**
 * Data Views API Client - client implementation
 */
class DataViewsApiClient {
  /**
   * constructor
   * @param http http dependency
   */
  constructor(http) {
    (0, _defineProperty2.default)(this, "http", void 0);
    this.http = http;
  }
  _request(url, query, body) {
    const request = body ? this.http.post(url, {
      query,
      body,
      version
    }) : this.http.fetch(url, {
      query,
      version
    });
    return request.catch(resp => {
      var _resp$body$attributes;
      if (resp.body.statusCode === 404 && ((_resp$body$attributes = resp.body.attributes) === null || _resp$body$attributes === void 0 ? void 0 : _resp$body$attributes.code) === 'no_matching_indices') {
        throw new _lib.DataViewMissingIndices(resp.body.message);
      }
      throw new Error(resp.body.message || resp.body.error || `${resp.body.statusCode} Response`);
    });
  }
  _getUrl(path) {
    return API_BASE_URL + path.filter(Boolean).map(encodeURIComponent).join('/');
  }

  /**
   * Get field list for a given index pattern
   * @param options options for fields request
   */
  getFieldsForWildcard(options) {
    const {
      pattern,
      metaFields,
      type,
      rollupIndex,
      allowNoIndex,
      indexFilter,
      includeUnmapped,
      fields
    } = options;
    return this._request(_constants.FIELDS_FOR_WILDCARD_PATH, {
      pattern,
      meta_fields: metaFields,
      type,
      rollup_index: rollupIndex,
      allow_no_index: allowNoIndex,
      include_unmapped: includeUnmapped,
      fields
    }, indexFilter ? JSON.stringify({
      index_filter: indexFilter
    }) : undefined).then(response => {
      return response || {
        fields: [],
        indices: []
      };
    });
  }

  /**
   * Does a user created data view exist?
   */
  async hasUserDataView() {
    var _response$result;
    const response = await this._request(this._getUrl(['has_user_index_pattern']));
    return (_response$result = response === null || response === void 0 ? void 0 : response.result) !== null && _response$result !== void 0 ? _response$result : false;
  }
}
exports.DataViewsApiClient = DataViewsApiClient;