"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColorFormatEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("@kbn/field-formats-plugin/common");
var _default = require("../default/default");
var _constants = require("./constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class ColorFormatEditor extends _default.DefaultFormatEditor {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "onColorChange", (newColorParams, index) => {
      const colors = [...this.props.formatParams.colors];
      colors[index] = {
        ...colors[index],
        ...newColorParams
      };
      this.onChange({
        colors
      });
    });
    (0, _defineProperty2.default)(this, "addColor", () => {
      const colors = [...(this.props.formatParams.colors || [])];
      this.onChange({
        colors: [...colors, {
          ..._common.DEFAULT_CONVERTER_COLOR
        }]
      });
    });
    (0, _defineProperty2.default)(this, "removeColor", index => {
      const colors = [...this.props.formatParams.colors];
      colors.splice(index, 1);
      this.onChange({
        colors
      });
    });
    this.onChange({
      fieldType: props.fieldType // FIXME: why add `fieldType` as an EditorFormatParam?
    });
  }

  render() {
    const {
      formatParams,
      fieldType
    } = this.props;
    const items = formatParams.colors && formatParams.colors.length && formatParams.colors.map((color, index) => {
      return {
        ...color,
        index
      };
    }) || [];
    const columns = [fieldType === 'string' ? {
      field: 'regex',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternFieldEditor.color.patternLabel",
        defaultMessage: "Pattern (regular expression)"
      }),
      render: (value, item) => {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
          value: value,
          "data-test-subj": `colorEditorKeyPattern ${item.index}`,
          onChange: e => {
            this.onColorChange({
              regex: e.target.value
            }, item.index);
          }
        });
      }
    } : {
      field: 'range',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternFieldEditor.color.rangeLabel",
        defaultMessage: "Range (min:max)"
      }),
      render: (value, item) => {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
          value: value,
          "data-test-subj": `colorEditorKeyRange ${item.index}`,
          onChange: e => {
            this.onColorChange({
              range: e.target.value
            }, item.index);
          }
        });
      }
    }, {
      field: 'text',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternFieldEditor.color.textColorLabel",
        defaultMessage: "Text color"
      }),
      render: (color, item) => {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiColorPicker, {
          color: color,
          "data-test-subj": `colorEditorColorPicker ${item.index}`,
          onChange: newColor => {
            this.onColorChange({
              text: newColor
            }, item.index);
          }
        });
      }
    }, {
      field: 'background',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternFieldEditor.color.backgroundLabel",
        defaultMessage: "Background color"
      }),
      render: (color, item) => {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiColorPicker, {
          color: color,
          "data-test-subj": `colorEditorBackgroundPicker ${item.index}`,
          onChange: newColor => {
            this.onColorChange({
              background: newColor
            }, item.index);
          }
        });
      }
    }, {
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternFieldEditor.color.exampleLabel",
        defaultMessage: "Example"
      }),
      render: item => {
        return /*#__PURE__*/_react.default.createElement("div", {
          style: {
            background: item.background,
            color: item.text
          }
        }, "123456");
      }
    }, {
      field: 'actions',
      name: _i18n.i18n.translate('indexPatternFieldEditor.color.actions', {
        defaultMessage: 'Actions'
      }),
      actions: [{
        name: _i18n.i18n.translate('indexPatternFieldEditor.color.deleteAria', {
          defaultMessage: 'Delete'
        }),
        description: _i18n.i18n.translate('indexPatternFieldEditor.color.deleteTitle', {
          defaultMessage: 'Delete color format'
        }),
        onClick: item => {
          this.removeColor(item.index);
        },
        type: 'icon',
        icon: 'trash',
        color: 'danger',
        available: () => items.length > 1,
        'data-test-subj': 'colorEditorRemoveColor'
      }]
    }];
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
      items: items,
      columns: columns
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconType: "plusInCircle",
      size: "s",
      onClick: this.addColor,
      "data-test-subj": 'colorEditorAddColor'
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "indexPatternFieldEditor.color.addColorButton",
      defaultMessage: "Add color"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }));
  }
}
exports.ColorFormatEditor = ColorFormatEditor;
(0, _defineProperty2.default)(ColorFormatEditor, "formatId", _constants.formatId);