"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LoadingIndices = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const LoadingIndices = ({
  ...rest
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, (0, _extends2.default)({
  justifyContent: "center",
  alignItems: "center",
  direction: "column",
  gutterSize: "s"
}, rest), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement("h3", {
  className: "eui-textCenter"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "indexPatternEditor.loadingHeader",
  defaultMessage: "Looking for matching indices\u2026"
})))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
  size: "l"
})));
exports.LoadingIndices = LoadingIndices;