"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRangeDisplayValue = getRangeDisplayValue;
exports.mapRange = exports.isMapRangeFilter = void 0;
var _lodash = require("lodash");
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getRangeDisplayValue({
  meta: {
    params
  }
}, formatter) {
  var _ref, _params$gte, _ref2, _params$lte;
  const left = (_ref = (_params$gte = params === null || params === void 0 ? void 0 : params.gte) !== null && _params$gte !== void 0 ? _params$gte : params === null || params === void 0 ? void 0 : params.gt) !== null && _ref !== void 0 ? _ref : -Infinity;
  const right = (_ref2 = (_params$lte = params === null || params === void 0 ? void 0 : params.lte) !== null && _params$lte !== void 0 ? _params$lte : params === null || params === void 0 ? void 0 : params.lt) !== null && _ref2 !== void 0 ? _ref2 : Infinity;
  if (!formatter) return `${left} to ${right}`;
  const convert = formatter.getConverterFor('text');
  return `${convert(left)} to ${convert(right)}`;
}
const getFirstRangeKey = filter => filter.query.range && Object.keys(filter.query.range)[0];
const getRangeByKey = (filter, key) => (0, _lodash.get)(filter.query, ['range', key]);
function getParams(filter) {
  const isScriptedRange = (0, _esQuery.isScriptedRangeFilter)(filter);
  const key = (isScriptedRange ? filter.meta.field : getFirstRangeKey(filter)) || '';
  const params = isScriptedRange ? (0, _lodash.get)(filter.query, 'script.script.params') : getRangeByKey(filter, key);
  return {
    type: _esQuery.FILTERS.RANGE,
    key,
    value: params,
    params
  };
}
const isMapRangeFilter = filter => (0, _esQuery.isRangeFilter)(filter) || (0, _esQuery.isScriptedRangeFilter)(filter);
exports.isMapRangeFilter = isMapRangeFilter;
const mapRange = filter => {
  if (!isMapRangeFilter(filter)) {
    throw filter;
  }
  return getParams(filter);
};
exports.mapRange = mapRange;