"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createFiltersFromMultiValueClickAction = void 0;
var _esQuery = require("@kbn/es-query");
var _create_filters_from_value_click = require("./create_filters_from_value_click");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/** @public */
const createFiltersFromMultiValueClickAction = async ({
  data,
  negate
}) => {
  var _table$meta;
  const {
    table,
    column,
    value
  } = data;
  const dataViewId = table === null || table === void 0 ? void 0 : (_table$meta = table.meta) === null || _table$meta === void 0 ? void 0 : _table$meta.source;
  if (!dataViewId) return;
  const columnId = table.columns[column].id;
  const filters = (await Promise.all(value.map(async v => {
    var _await$createFilter;
    return (_await$createFilter = await (0, _create_filters_from_value_click.createFilter)(table, column, table.rows.findIndex(r => r[columnId] === v))) === null || _await$createFilter === void 0 ? void 0 : _await$createFilter[0];
  }))).filter(Boolean);
  if (filters.length === 0) return;
  // no need for combined filter in case of one filter
  if (filters.length === 1) {
    if (filters[0] && negate) {
      return (0, _esQuery.toggleFilterNegated)(filters[0]);
    }
    return filters[0];
  }
  const filtersHaveAlias = filters.every(f => f.meta.alias);
  let alias = '';
  if (filtersHaveAlias) {
    filters.forEach((f, i) => {
      if (i === filters.length - 1) {
        alias += `${f.meta.alias}`;
      } else {
        alias += `${f.meta.alias} ${_esQuery.BooleanRelation.OR} `;
      }
    });
  }
  let filter = (0, _esQuery.buildCombinedFilter)(_esQuery.BooleanRelation.OR, filters, {
    id: dataViewId
  }, undefined, undefined, alias);
  if (filter && negate) {
    filter = (0, _esQuery.toggleFilterNegated)(filter);
  }
  return filter;
};
exports.createFiltersFromMultiValueClickAction = createFiltersFromMultiValueClickAction;