"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.aggTimeSeriesFnName = exports.aggTimeSeries = void 0;
var _i18n = require("@kbn/i18n");
var _ = require("..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const aggTimeSeriesFnName = 'aggTimeSeries';
exports.aggTimeSeriesFnName = aggTimeSeriesFnName;
const aggTimeSeries = () => ({
  name: aggTimeSeriesFnName,
  help: _i18n.i18n.translate('data.search.aggs.function.buckets.timeSeries.help', {
    defaultMessage: 'Generates a serialized agg config for a Time Series agg'
  }),
  type: 'agg_type',
  args: {
    id: {
      types: ['string'],
      help: _i18n.i18n.translate('data.search.aggs.buckets.timeSeries.id.help', {
        defaultMessage: 'ID for this aggregation'
      })
    },
    enabled: {
      types: ['boolean'],
      default: true,
      help: _i18n.i18n.translate('data.search.aggs.buckets.timeSeries.enabled.help', {
        defaultMessage: 'Specifies whether this aggregation should be enabled'
      })
    },
    schema: {
      types: ['string'],
      help: _i18n.i18n.translate('data.search.aggs.buckets.timeSeries.schema.help', {
        defaultMessage: 'Schema to use for this aggregation'
      })
    },
    customLabel: {
      types: ['string'],
      help: _i18n.i18n.translate('data.search.aggs.buckets.terms.customLabel.help', {
        defaultMessage: 'Represents a custom label for this aggregation'
      })
    }
  },
  fn: (input, args) => {
    const {
      id,
      enabled,
      schema,
      ...rest
    } = args;
    return {
      type: 'agg_type',
      value: {
        id,
        enabled,
        schema,
        type: _.BUCKET_TYPES.TIME_SERIES,
        params: {
          ...rest
        }
      }
    };
  }
});
exports.aggTimeSeries = aggTimeSeries;