"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dashboardContentManagementServiceFactory = void 0;
var _check_for_duplicate_dashboard_title = require("./lib/check_for_duplicate_dashboard_title");
var _find_dashboards = require("./lib/find_dashboards");
var _save_dashboard_state = require("./lib/save_dashboard_state");
var _load_dashboard_state = require("./lib/load_dashboard_state");
var _delete_dashboards = require("./lib/delete_dashboards");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const dashboardContentManagementServiceFactory = ({
  startPlugins: {
    contentManagement
  }
}, requiredServices) => {
  const {
    data,
    embeddable,
    notifications,
    initializerContext,
    savedObjectsTagging,
    dashboardSessionStorage
  } = requiredServices;
  return {
    loadDashboardState: ({
      id
    }) => (0, _load_dashboard_state.loadDashboardState)({
      id,
      data,
      embeddable,
      contentManagement,
      savedObjectsTagging
    }),
    saveDashboardState: ({
      currentState,
      saveOptions,
      lastSavedId
    }) => (0, _save_dashboard_state.saveDashboardState)({
      data,
      embeddable,
      saveOptions,
      lastSavedId,
      currentState,
      notifications,
      contentManagement,
      initializerContext,
      savedObjectsTagging,
      dashboardSessionStorage
    }),
    findDashboards: {
      search: ({
        hasReference,
        hasNoReference,
        search,
        size
      }) => (0, _find_dashboards.searchDashboards)({
        contentManagement,
        hasNoReference,
        hasReference,
        search,
        size
      }),
      findByIds: ids => (0, _find_dashboards.findDashboardsByIds)(contentManagement, ids),
      findByTitle: title => (0, _find_dashboards.findDashboardIdByTitle)(contentManagement, title)
    },
    checkForDuplicateDashboardTitle: props => (0, _check_for_duplicate_dashboard_title.checkForDuplicateDashboardTitle)(props, contentManagement),
    deleteDashboards: ids => (0, _delete_dashboards.deleteDashboards)(ids, contentManagement)
  };
};
exports.dashboardContentManagementServiceFactory = dashboardContentManagementServiceFactory;