"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.DashboardListing = void 0;
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _contentManagementTableListViewTable = require("@kbn/content-management-table-list-view-table");
var _contentManagementTableListView = require("@kbn/content-management-table-list-view");
var _public = require("@kbn/embeddable-plugin/public");
var _ebtTools = require("@kbn/ebt-tools");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _dashboard_constants = require("../dashboard_constants");
var _dashboard_listing_strings = require("./_dashboard_listing_strings");
var _plugin_services = require("../services/plugin_services");
var _confirm_overlays = require("./confirm_overlays");
var _dashboard_unsaved_listing = require("./dashboard_unsaved_listing");
var _dashboard_listing_empty_prompt = require("./dashboard_listing_empty_prompt");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const SAVED_OBJECTS_LIMIT_SETTING = 'savedObjects:listingLimit';
const SAVED_OBJECTS_PER_PAGE_SETTING = 'savedObjects:perPage';
const toTableListViewSavedObject = hit => {
  const {
    title,
    description,
    timeRestore
  } = hit.attributes;
  return {
    type: 'dashboard',
    id: hit.id,
    updatedAt: hit.updatedAt,
    references: hit.references,
    attributes: {
      title,
      description,
      timeRestore
    }
  };
};
const DashboardListing = ({
  children,
  initialFilter,
  goToDashboard,
  getDashboardUrl,
  useSessionStorageIntegration
}) => {
  const {
    application,
    notifications,
    overlays,
    http,
    savedObjectsTagging,
    dashboardSessionStorage,
    settings: {
      uiSettings
    },
    notifications: {
      toasts
    },
    coreContext: {
      executionContext
    },
    dashboardCapabilities: {
      showWriteControls
    },
    dashboardContentManagement: {
      findDashboards,
      deleteDashboards
    }
  } = _plugin_services.pluginServices.getServices();
  const [unsavedDashboardIds, setUnsavedDashboardIds] = (0, _react.useState)(dashboardSessionStorage.getDashboardIdsWithUnsavedChanges());
  (0, _public2.useExecutionContext)(executionContext, {
    type: 'application',
    page: 'list'
  });
  const listingLimit = uiSettings.get(SAVED_OBJECTS_LIMIT_SETTING);
  const initialPageSize = uiSettings.get(SAVED_OBJECTS_PER_PAGE_SETTING);
  const createItem = (0, _react.useCallback)(() => {
    if (useSessionStorageIntegration && dashboardSessionStorage.dashboardHasUnsavedEdits()) {
      (0, _confirm_overlays.confirmCreateWithUnsaved)(() => {
        dashboardSessionStorage.clearState();
        goToDashboard();
      }, goToDashboard);
      return;
    }
    goToDashboard();
  }, [dashboardSessionStorage, goToDashboard, useSessionStorageIntegration]);
  const fetchItems = (0, _react.useCallback)((searchTerm, {
    references,
    referencesToExclude
  } = {}) => {
    const searchStartTime = window.performance.now();
    return findDashboards.search({
      search: searchTerm,
      size: listingLimit,
      hasReference: references,
      hasNoReference: referencesToExclude
    }).then(({
      total,
      hits
    }) => {
      const searchEndTime = window.performance.now();
      const searchDuration = searchEndTime - searchStartTime;
      (0, _ebtTools.reportPerformanceMetricEvent)(_plugin_services.pluginServices.getServices().analytics, {
        eventName: _dashboard_constants.SAVED_OBJECT_LOADED_TIME,
        duration: searchDuration,
        meta: {
          saved_object_type: _dashboard_constants.DASHBOARD_CONTENT_ID
        }
      });
      return {
        total,
        hits: hits.map(toTableListViewSavedObject)
      };
    });
  }, [findDashboards, listingLimit]);
  const deleteItems = (0, _react.useCallback)(async dashboardsToDelete => {
    try {
      const deleteStartTime = window.performance.now();
      await deleteDashboards(dashboardsToDelete.map(({
        id
      }) => {
        dashboardSessionStorage.clearState(id);
        return id;
      }));
      const deleteDuration = window.performance.now() - deleteStartTime;
      (0, _ebtTools.reportPerformanceMetricEvent)(_plugin_services.pluginServices.getServices().analytics, {
        eventName: _dashboard_constants.SAVED_OBJECT_DELETE_TIME,
        duration: deleteDuration,
        meta: {
          saved_object_type: _dashboard_constants.DASHBOARD_CONTENT_ID,
          total: dashboardsToDelete.length
        }
      });
    } catch (error) {
      toasts.addError(error, {
        title: _dashboard_listing_strings.dashboardListingErrorStrings.getErrorDeletingDashboardToast()
      });
    }
    setUnsavedDashboardIds(dashboardSessionStorage.getDashboardIdsWithUnsavedChanges());
  }, [dashboardSessionStorage, deleteDashboards, toasts]);
  const editItem = (0, _react.useCallback)(({
    id
  }) => goToDashboard(id, _public.ViewMode.EDIT), [goToDashboard]);
  const emptyPrompt = /*#__PURE__*/_react.default.createElement(_dashboard_listing_empty_prompt.DashboardListingEmptyPrompt, {
    createItem: createItem,
    goToDashboard: goToDashboard,
    unsavedDashboardIds: unsavedDashboardIds,
    setUnsavedDashboardIds: setUnsavedDashboardIds,
    useSessionStorageIntegration: useSessionStorageIntegration
  });
  const {
    getEntityName,
    getTableListTitle,
    getEntityNamePlural
  } = _dashboard_listing_strings.dashboardListingTableStrings;
  const savedObjectsTaggingFakePlugin = (0, _react.useMemo)(() => {
    return savedObjectsTagging.hasApi // TODO: clean up this logic once https://github.com/elastic/kibana/issues/140433 is resolved
    ? {
      ui: savedObjectsTagging
    } : undefined;
  }, [savedObjectsTagging]);
  return /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_contentManagementTableListViewTable.TableListViewKibanaProvider, {
    core: {
      application: application,
      notifications,
      overlays,
      http
    },
    toMountPoint: _public2.toMountPoint,
    savedObjectsTagging: savedObjectsTaggingFakePlugin,
    FormattedRelative: _i18nReact.FormattedRelative
  }, /*#__PURE__*/_react.default.createElement(_contentManagementTableListView.TableListView, {
    getDetailViewLink: ({
      id,
      attributes: {
        timeRestore
      }
    }) => getDashboardUrl(id, timeRestore),
    deleteItems: !showWriteControls ? undefined : deleteItems,
    createItem: !showWriteControls ? undefined : createItem,
    editItem: !showWriteControls ? undefined : editItem,
    entityNamePlural: getEntityNamePlural(),
    title: getTableListTitle(),
    headingId: "dashboardListingHeading",
    initialPageSize: initialPageSize,
    initialFilter: initialFilter,
    entityName: getEntityName(),
    listingLimit: listingLimit,
    emptyPrompt: emptyPrompt,
    findItems: fetchItems,
    id: "dashboard"
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children, /*#__PURE__*/_react.default.createElement(_dashboard_unsaved_listing.DashboardUnsavedListing, {
    goToDashboard: goToDashboard,
    unsavedDashboardIds: unsavedDashboardIds,
    refreshUnsavedDashboards: () => setUnsavedDashboardIds(dashboardSessionStorage.getDashboardIdsWithUnsavedChanges())
  })))));
};

// eslint-disable-next-line import/no-default-export
exports.DashboardListing = DashboardListing;
var _default = DashboardListing;
exports.default = _default;