"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDebouncedWidthObserver = exports.DashboardViewportComponent = exports.DashboardViewport = void 0;
var _lodash = require("lodash");
var _classnames = _interopRequireDefault(require("classnames"));
var _polyfilled = _interopRequireDefault(require("use-resize-observer/polyfilled"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/embeddable-plugin/public");
var _sharedUxButtonExitFullScreen = require("@kbn/shared-ux-button-exit-full-screen");
var _grid = require("../grid");
var _plugin_services = require("../../../services/plugin_services");
var _dashboard_container = require("../../embeddable/dashboard_container");
var _dashboard_empty_screen = require("../empty_screen/dashboard_empty_screen");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const useDebouncedWidthObserver = (wait = 250) => {
  const [width, setWidth] = (0, _react.useState)(0);
  const onWidthChange = (0, _react.useMemo)(() => (0, _lodash.debounce)(setWidth, wait), [wait]);
  const {
    ref
  } = (0, _polyfilled.default)({
    onResize: dimensions => {
      if (dimensions.width) {
        if (width === 0) setWidth(dimensions.width);
        if (dimensions.width !== width) onWidthChange(dimensions.width);
      }
    }
  });
  return {
    ref,
    width
  };
};
exports.useDebouncedWidthObserver = useDebouncedWidthObserver;
const DashboardViewportComponent = () => {
  var _dashboard$select;
  const {
    settings: {
      isProjectEnabledInLabs
    }
  } = _plugin_services.pluginServices.getServices();
  const controlsRoot = (0, _react.useRef)(null);
  const dashboard = (0, _dashboard_container.useDashboardContainer)();

  /**
   * Render Control group
   */
  const controlGroup = dashboard.controlGroup;
  (0, _react.useEffect)(() => {
    if (controlGroup && controlsRoot.current) controlGroup.render(controlsRoot.current);
  }, [controlGroup]);
  const panelCount = Object.keys(dashboard.select(state => state.explicitInput.panels)).length;
  const controlCount = Object.keys((_dashboard$select = dashboard.select(state => {
    var _state$explicitInput$;
    return (_state$explicitInput$ = state.explicitInput.controlGroupInput) === null || _state$explicitInput$ === void 0 ? void 0 : _state$explicitInput$.panels;
  })) !== null && _dashboard$select !== void 0 ? _dashboard$select : {}).length;
  const viewMode = dashboard.select(state => state.explicitInput.viewMode);
  const dashboardTitle = dashboard.select(state => state.explicitInput.title);
  const description = dashboard.select(state => state.explicitInput.description);
  const expandedPanelId = dashboard.select(state => state.componentState.expandedPanelId);
  const controlsEnabled = isProjectEnabledInLabs('labs:dashboard:dashboardControls');
  const {
    ref: resizeRef,
    width: viewportWidth
  } = useDebouncedWidthObserver();
  const classes = (0, _classnames.default)({
    dshDashboardViewport: true,
    'dshDashboardViewport--panelExpanded': Boolean(expandedPanelId)
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    className: 'dshDashboardViewportWrapper'
  }, controlsEnabled && controlGroup && viewMode !== _public.ViewMode.PRINT ? /*#__PURE__*/_react.default.createElement("div", {
    className: controlCount > 0 ? 'dshDashboardViewport-controls' : '',
    ref: controlsRoot
  }) : null, panelCount === 0 && /*#__PURE__*/_react.default.createElement(_dashboard_empty_screen.DashboardEmptyScreen, null), /*#__PURE__*/_react.default.createElement("div", {
    ref: resizeRef,
    className: classes,
    "data-shared-items-container": true,
    "data-title": dashboardTitle,
    "data-description": description,
    "data-shared-items-count": panelCount
  }, /*#__PURE__*/_react.default.createElement(_grid.DashboardGrid, {
    viewportWidth: viewportWidth
  })));
};

// This fullscreen button HOC separates fullscreen button and dashboard content to reduce rerenders
// because ExitFullScreenButton sets isFullscreenMode to false on unmount while rerendering.
// This specifically fixed maximizing/minimizing panels without exiting fullscreen mode.
exports.DashboardViewportComponent = DashboardViewportComponent;
const WithFullScreenButton = ({
  children
}) => {
  const dashboard = (0, _dashboard_container.useDashboardContainer)();
  const isFullScreenMode = dashboard.select(state => state.componentState.fullScreenMode);
  const isEmbeddedExternally = dashboard.select(state => state.componentState.isEmbeddedExternally);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children, isFullScreenMode && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_sharedUxButtonExitFullScreen.ExitFullScreenButton, {
    onExit: () => dashboard.dispatch.setFullScreenMode(false),
    toggleChrome: !isEmbeddedExternally
  })));
};
const DashboardViewport = () => /*#__PURE__*/_react.default.createElement(WithFullScreenButton, null, /*#__PURE__*/_react.default.createElement(DashboardViewportComponent, null));
exports.DashboardViewport = DashboardViewport;