"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardSettings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useMountedState = _interopRequireDefault(require("react-use/lib/useMountedState"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _plugin_services = require("../../../services/plugin_services");
var _dashboard_container = require("../../embeddable/dashboard_container");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DUPLICATE_TITLE_CALLOUT_ID = 'duplicateTitleCallout';
const DashboardSettings = ({
  onClose
}) => {
  var _dashboardSettingsSta;
  const {
    savedObjectsTagging: {
      components
    },
    dashboardContentManagement: {
      checkForDuplicateDashboardTitle
    }
  } = _plugin_services.pluginServices.getServices();
  const dashboard = (0, _dashboard_container.useDashboardContainer)();
  const [dashboardSettingsState, setDashboardSettingsState] = (0, _react.useState)({
    ...dashboard.getInput()
  });
  const [isTitleDuplicate, setIsTitleDuplicate] = (0, _react.useState)(false);
  const [isTitleDuplicateConfirmed, setIsTitleDuplicateConfirmed] = (0, _react.useState)(false);
  const [isApplying, setIsApplying] = (0, _react.useState)(false);
  const lastSavedId = dashboard.select(state => state.componentState.lastSavedId);
  const lastSavedTitle = dashboard.select(state => state.explicitInput.title);
  const isMounted = (0, _useMountedState.default)();
  const onTitleDuplicate = () => {
    if (!isMounted()) return;
    setIsTitleDuplicate(true);
    setIsTitleDuplicateConfirmed(true);
  };
  const onApply = async () => {
    setIsApplying(true);
    const validTitle = await checkForDuplicateDashboardTitle({
      title: dashboardSettingsState.title,
      copyOnSave: false,
      lastSavedTitle,
      onTitleDuplicate,
      isTitleDuplicateConfirmed
    });
    if (!isMounted()) return;
    setIsApplying(false);
    if (validTitle) {
      dashboard.dispatch.setStateFromSettingsFlyout({
        lastSavedId,
        ...dashboardSettingsState
      });
      onClose();
    }
  };
  const updateDashboardSetting = (0, _react.useCallback)(newSettings => {
    setDashboardSettingsState(prevDashboardSettingsState => {
      return {
        ...prevDashboardSettingsState,
        ...newSettings
      };
    });
  }, []);
  const renderDuplicateTitleCallout = () => {
    if (!isTitleDuplicate) {
      return;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "dashboard.embeddableApi.showSettings.flyout.form.duplicateTitleLabel",
        defaultMessage: "This dashboard already exists"
      }),
      color: "warning",
      "data-test-subj": "duplicateTitleWarningMessage",
      id: DUPLICATE_TITLE_CALLOUT_ID
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "dashboard.embeddableApi.showSettings.flyout.form.duplicateTitleDescription",
      defaultMessage: "Saving '{title}' creates a duplicate title.",
      values: {
        title: dashboardSettingsState.title
      }
    })));
  };
  const renderTagSelector = () => {
    if (!components) return;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "dashboard.embeddableApi.showSettings.flyout.form.tagsFormRowLabel",
        defaultMessage: "Tags"
      })
    }, /*#__PURE__*/_react.default.createElement(components.TagSelector, {
      selected: dashboardSettingsState.tags,
      onTagsSelected: selectedTags => updateDashboardSetting({
        tags: selectedTags
      })
    }));
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "dashboard.embeddableApi.showSettings.flyout.title",
    defaultMessage: "Dashboard settings"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, renderDuplicateTitleCallout(), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    "data-test-subj": "dashboardSettingsPanel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "dashboard.embeddableApi.showSettings.flyout.form.panelTitleFormRowLabel",
      defaultMessage: "Title"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    id: "dashboardTitleInput",
    className: "dashboardTitleInputText",
    "data-test-subj": "dashboardTitleInput",
    name: "title",
    type: "text",
    value: dashboardSettingsState.title,
    onChange: event => {
      setIsTitleDuplicate(false);
      setIsTitleDuplicateConfirmed(false);
      updateDashboardSetting({
        title: event.target.value
      });
    },
    "aria-label": _i18n.i18n.translate('dashboard.embeddableApi.showSettings.flyout.form.panelTitleInputAriaLabel', {
      defaultMessage: 'Change the dashboard title'
    }),
    "aria-describedby": isTitleDuplicate ? DUPLICATE_TITLE_CALLOUT_ID : undefined
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "dashboard.embeddableApi.showSettings.flyout.form.panelDescriptionFormRowLabel",
      defaultMessage: "Description"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    id: "dashboardDescriptionInput",
    className: "dashboardDescriptionInputText",
    "data-test-subj": "dashboardDescriptionInput",
    name: "description",
    value: (_dashboardSettingsSta = dashboardSettingsState.description) !== null && _dashboardSettingsSta !== void 0 ? _dashboardSettingsSta : '',
    onChange: event => updateDashboardSetting({
      description: event.target.value
    }),
    "aria-label": _i18n.i18n.translate('dashboard.embeddableApi.showSettings.flyout.form.panelDescriptionAriaLabel', {
      defaultMessage: 'Change the dashboard description'
    })
  })), renderTagSelector(), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "dashboard.embeddableApi.showSettings.flyout.form.storeTimeWithDashboardFormRowHelpText",
      defaultMessage: "This changes the time filter to the currently selected time each time this dashboard is loaded."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": "storeTimeWithDashboard",
    checked: dashboardSettingsState.timeRestore,
    onChange: event => updateDashboardSetting({
      timeRestore: event.target.checked
    }),
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "dashboard.embeddableApi.showSettings.flyout.form.storeTimeWithDashboardFormRowLabel",
      defaultMessage: "Store time with dashboard"
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('dashboard.embeddableApi.showSettings.flyout.form.useMarginsBetweenPanelsSwitchLabel', {
      defaultMessage: 'Use margins between panels'
    }),
    checked: dashboardSettingsState.useMargins,
    onChange: event => updateDashboardSetting({
      useMargins: event.target.checked
    }),
    "data-test-subj": "dashboardMarginsCheckbox"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('dashboard.embeddableApi.showSettings.flyout.form.hideAllPanelTitlesSwitchLabel', {
      defaultMessage: 'Show panel titles'
    }),
    checked: !dashboardSettingsState.hidePanelTitles,
    onChange: event => updateDashboardSetting({
      hidePanelTitles: !event.target.checked
    }),
    "data-test-subj": "dashboardPanelTitlesCheckbox"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: "Sync across panels"
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('dashboard.embeddableApi.showSettings.flyout.form.syncColorsBetweenPanelsSwitchLabel', {
      defaultMessage: 'Sync color palettes across panels'
    }),
    checked: dashboardSettingsState.syncColors,
    onChange: event => updateDashboardSetting({
      syncColors: event.target.checked
    }),
    "data-test-subj": "dashboardSyncColorsCheckbox"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('dashboard.embeddableApi.showSettings.flyout.form.syncCursorBetweenPanelsSwitchLabel', {
      defaultMessage: 'Sync cursor across panels'
    }),
    checked: dashboardSettingsState.syncCursor,
    onChange: event => {
      const syncCursor = event.target.checked;
      if (!syncCursor && dashboardSettingsState.syncTooltips) {
        updateDashboardSetting({
          syncCursor,
          syncTooltips: false
        });
      } else {
        updateDashboardSetting({
          syncCursor
        });
      }
    },
    "data-test-subj": "dashboardSyncCursorCheckbox"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('dashboard.embeddableApi.showSettings.flyout.form.syncTooltipsBetweenPanelsSwitchLabel', {
      defaultMessage: 'Sync tooltips across panels'
    }),
    checked: dashboardSettingsState.syncTooltips,
    disabled: !Boolean(dashboardSettingsState.syncCursor),
    onChange: event => updateDashboardSetting({
      syncTooltips: event.target.checked
    }),
    "data-test-subj": "dashboardSyncTooltipsCheckbox"
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "cancelCustomizeDashboardButton",
    onClick: onClose
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "dashboard.embeddableApi.showSettings.flyout.cancelButtonTitle",
    defaultMessage: "Cancel"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "applyCustomizeDashboardButton",
    onClick: onApply,
    fill: true,
    "aria-describedby": isTitleDuplicate ? DUPLICATE_TITLE_CALLOUT_ID : undefined,
    isLoading: isApplying
  }, isTitleDuplicate ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "dashboard.embeddableApi.showSettings.flyout.confirmApplyButtonTitle",
    defaultMessage: "Confirm and apply"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "dashboard.embeddableApi.showSettings.flyout.applyButtonTitle",
    defaultMessage: "Apply"
  }))))));
};
exports.DashboardSettings = DashboardSettings;