"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShowShareModal = ShowShareModal;
exports.showPublicUrlSwitch = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _dashboard_router = require("../../dashboard_router");
var _dashboard_app_strings = require("../../_dashboard_app_strings");
var _plugin_services = require("../../../services/plugin_services");
var _common = require("../../../../common");
var _locator = require("../../locator/locator");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const showFilterBarId = 'showFilterBar';
const showPublicUrlSwitch = anonymousUserCapabilities => {
  if (!anonymousUserCapabilities.dashboard) return false;
  const dashboard = anonymousUserCapabilities.dashboard;
  return !!dashboard.show;
};
exports.showPublicUrlSwitch = showPublicUrlSwitch;
function ShowShareModal({
  isDirty,
  anchorElement,
  savedObjectId,
  dashboardTitle
}) {
  var _g2;
  const {
    dashboardCapabilities: {
      createShortUrl: allowShortUrl
    },
    dashboardSessionStorage,
    data: {
      query: {
        timefilter: {
          timefilter: {
            getTime
          }
        }
      }
    },
    initializerContext: {
      kibanaVersion
    },
    share: {
      toggleShareContextMenu
    }
  } = _plugin_services.pluginServices.getServices();
  if (!toggleShareContextMenu) return; // TODO: Make this logic cleaner once share is an optional service

  const EmbedUrlParamExtension = ({
    setParamValue
  }) => {
    const [urlParamsSelectedMap, seturlParamsSelectedMap] = (0, _react.useState)({
      showFilterBar: true
    });
    const checkboxes = [{
      id: _dashboard_router.dashboardUrlParams.showTopMenu,
      label: _dashboard_app_strings.shareModalStrings.getTopMenuCheckbox()
    }, {
      id: _dashboard_router.dashboardUrlParams.showQueryInput,
      label: _dashboard_app_strings.shareModalStrings.getQueryCheckbox()
    }, {
      id: _dashboard_router.dashboardUrlParams.showTimeFilter,
      label: _dashboard_app_strings.shareModalStrings.getTimeFilterCheckbox()
    }, {
      id: showFilterBarId,
      label: _dashboard_app_strings.shareModalStrings.getFilterBarCheckbox()
    }];
    const handleChange = param => {
      const newSelectedMap = {
        ...urlParamsSelectedMap,
        [param]: !urlParamsSelectedMap[param]
      };
      const urlParamValues = {
        [_dashboard_router.dashboardUrlParams.showTopMenu]: newSelectedMap[_dashboard_router.dashboardUrlParams.showTopMenu],
        [_dashboard_router.dashboardUrlParams.showQueryInput]: newSelectedMap[_dashboard_router.dashboardUrlParams.showQueryInput],
        [_dashboard_router.dashboardUrlParams.showTimeFilter]: newSelectedMap[_dashboard_router.dashboardUrlParams.showTimeFilter],
        [_dashboard_router.dashboardUrlParams.hideFilterBar]: !newSelectedMap[showFilterBarId]
      };
      seturlParamsSelectedMap(newSelectedMap);
      setParamValue(urlParamValues);
    };
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCheckboxGroup, {
      options: checkboxes,
      idToSelectedMap: urlParamsSelectedMap,
      onChange: handleChange,
      legend: {
        children: _dashboard_app_strings.shareModalStrings.getCheckboxLegend()
      },
      "data-test-subj": "embedUrlParamExtension"
    });
  };
  let unsavedStateForLocator = {};
  const unsavedDashboardState = dashboardSessionStorage.getState(savedObjectId);
  if (unsavedDashboardState) {
    unsavedStateForLocator = {
      query: unsavedDashboardState.query,
      filters: unsavedDashboardState.filters,
      controlGroupInput: unsavedDashboardState.controlGroupInput,
      panels: unsavedDashboardState.panels ? (0, _common.convertPanelMapToSavedPanels)(unsavedDashboardState.panels, kibanaVersion) : undefined,
      // options
      useMargins: unsavedDashboardState === null || unsavedDashboardState === void 0 ? void 0 : unsavedDashboardState.useMargins,
      syncColors: unsavedDashboardState === null || unsavedDashboardState === void 0 ? void 0 : unsavedDashboardState.syncColors,
      syncCursor: unsavedDashboardState === null || unsavedDashboardState === void 0 ? void 0 : unsavedDashboardState.syncCursor,
      syncTooltips: unsavedDashboardState === null || unsavedDashboardState === void 0 ? void 0 : unsavedDashboardState.syncTooltips,
      hidePanelTitles: unsavedDashboardState === null || unsavedDashboardState === void 0 ? void 0 : unsavedDashboardState.hidePanelTitles
    };
  }
  const locatorParams = {
    dashboardId: savedObjectId,
    preserveSavedFilters: true,
    refreshInterval: undefined,
    // We don't share refresh interval externally
    viewMode: _public.ViewMode.VIEW,
    // For share locators we always load the dashboard in view mode
    useHash: false,
    timeRange: getTime(),
    ...unsavedStateForLocator
  };
  let _g = (0, _public2.getStateFromKbnUrl)('_g', window.location.href);
  if ((_g2 = _g) !== null && _g2 !== void 0 && _g2.filters && _g.filters.length === 0) {
    _g = (0, _lodash.omit)(_g, 'filters');
  }
  const baseUrl = (0, _public2.setStateToKbnUrl)('_g', _g, undefined, window.location.href);
  const shareableUrl = (0, _public2.setStateToKbnUrl)('_a', unsavedStateForLocator, {
    useHash: false,
    storeInHashQuery: true
  }, (0, _public2.unhashUrl)(baseUrl));
  toggleShareContextMenu({
    isDirty,
    anchorElement,
    allowEmbed: true,
    allowShortUrl,
    shareableUrl,
    objectId: savedObjectId,
    objectType: 'dashboard',
    sharingData: {
      title: dashboardTitle || _i18n.i18n.translate('dashboard.share.defaultDashboardTitle', {
        defaultMessage: 'Dashboard [{date}]',
        values: {
          date: (0, _moment.default)().toISOString(true)
        }
      }),
      locatorParams: {
        id: _locator.DASHBOARD_APP_LOCATOR,
        params: locatorParams
      }
    },
    embedUrlParamExtensions: [{
      paramName: 'embed',
      component: EmbedUrlParamExtension
    }],
    showPublicUrlSwitch,
    snapshotShareWarning: Boolean(unsavedDashboardState === null || unsavedDashboardState === void 0 ? void 0 : unsavedDashboardState.panels) ? _dashboard_app_strings.shareModalStrings.getSnapshotShareWarning() : undefined
  });
}