"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardNoMatch = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _dashboard_constants = require("../../dashboard_constants");
var _plugin_services = require("../../services/plugin_services");
var _dashboard_mount_context = require("../hooks/dashboard_mount_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

let bannerId;
const DashboardNoMatch = ({
  history
}) => {
  const {
    restorePreviousUrl
  } = (0, _dashboard_mount_context.useDashboardMountContext)();
  const {
    settings: {
      theme: {
        theme$
      }
    },
    overlays: {
      banners
    },
    urlForwarding: {
      navigateToLegacyKibanaUrl
    }
  } = _plugin_services.pluginServices.getServices();
  (0, _react.useEffect)(() => {
    restorePreviousUrl();
    const {
      navigated
    } = navigateToLegacyKibanaUrl(history.location.pathname + history.location.search);
    if (!navigated) {
      const bannerMessage = _i18n.i18n.translate('dashboard.noMatchRoute.bannerTitleText', {
        defaultMessage: 'Page not found'
      });
      bannerId = banners.replace(bannerId, (0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        color: "warning",
        iconType: "iInCircle",
        title: bannerMessage
      }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "dashboard.noMatchRoute.bannerText",
        defaultMessage: "Dashboard application doesn't recognize this route: {route}.",
        values: {
          route: history.location.pathname
        }
      }))), {
        theme$
      }));

      // hide the message after the user has had a chance to acknowledge it -- so it doesn't permanently stick around
      setTimeout(() => {
        if (bannerId) {
          banners.remove(bannerId);
        }
      }, 15000);
      history.replace(_dashboard_constants.LANDING_PAGE_PATH);
    }
  }, [restorePreviousUrl, navigateToLegacyKibanaUrl, banners, theme$, history]);
  return null;
};
exports.DashboardNoMatch = DashboardNoMatch;